/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class RemoteExceptionHandler {
    private RemoteExceptionHandler() {
    }

    public static Throwable checkThrowable(Throwable t) {
        Throwable result2 = t;
        if (t instanceof RemoteException) {
            try {
                result2 = RemoteExceptionHandler.decodeRemoteException((RemoteException)t);
            }
            catch (Throwable tt) {
                result2 = tt;
            }
        }
        return result2;
    }

    public static IOException checkIOException(IOException e) {
        Throwable t = RemoteExceptionHandler.checkThrowable(e);
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    public static IOException decodeRemoteException(RemoteException re) throws IOException {
        IOException i = re;
        try {
            Class<?> c = Class.forName(re.getClassName());
            Class[] parameterTypes = new Class[]{String.class};
            Constructor<?> ctor = c.getConstructor(parameterTypes);
            Object[] arguments = new Object[]{re.getMessage()};
            Throwable t = (Throwable)ctor.newInstance(arguments);
            if (!(t instanceof IOException)) {
                i = new IOException("server error");
                i.initCause(t);
                throw i;
            }
            i = (IOException)t;
        }
        catch (ClassNotFoundException x) {
        }
        catch (NoSuchMethodException x) {
        }
        catch (IllegalAccessException x) {
        }
        catch (InvocationTargetException x) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return i;
    }
}

