/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;

public class JMXListener
implements Coprocessor {
    public static final Log LOG = LogFactory.getLog(JMXListener.class);
    public static final String RMI_REGISTRY_PORT_CONF_KEY = ".rmi.registry.port";
    public static final String RMI_CONNECTOR_PORT_CONF_KEY = ".rmi.connector.port";
    public static int defMasterRMIRegistryPort = 10101;
    public static int defRegionserverRMIRegistryPort = 10102;
    private JMXConnectorServer jmxCS = null;

    public static JMXServiceURL buildJMXServiceURL(int rmiRegistryPort, int rmiConnectorPort) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append("service:jmx:rmi://localhost:");
        url.append(rmiConnectorPort);
        url.append("/jndi/rmi://localhost:");
        url.append(rmiRegistryPort);
        url.append("/jmxrmi");
        return new JMXServiceURL(url.toString());
    }

    public void startConnectorServer(int rmiRegistryPort, int rmiConnectorPort) throws IOException {
        boolean rmiSSL = false;
        boolean authenticate = true;
        String passwordFile = null;
        String accessFile = null;
        System.setProperty("java.rmi.server.randomIDs", "true");
        String rmiSSLValue = System.getProperty("com.sun.management.jmxremote.ssl", "false");
        rmiSSL = Boolean.parseBoolean(rmiSSLValue);
        String authenticateValue = System.getProperty("com.sun.management.jmxremote.authenticate", "false");
        authenticate = Boolean.parseBoolean(authenticateValue);
        passwordFile = System.getProperty("com.sun.management.jmxremote.password.file");
        accessFile = System.getProperty("com.sun.management.jmxremote.access.file");
        LOG.info("rmiSSL:" + rmiSSLValue + ",authenticate:" + authenticateValue + ",passwordFile:" + passwordFile + ",accessFile:" + accessFile);
        HashMap<String, Object> jmxEnv = new HashMap<String, Object>();
        SslRMIClientSocketFactory csf = null;
        SslRMIServerSocketFactory ssf = null;
        if (rmiSSL) {
            if (rmiRegistryPort == rmiConnectorPort) {
                throw new IOException("SSL is enabled. rmiConnectorPort cannot share with the rmiRegistryPort!");
            }
            csf = new SslRMIClientSocketFactory();
            ssf = new SslRMIServerSocketFactory();
        }
        if (csf != null) {
            jmxEnv.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        if (ssf != null) {
            jmxEnv.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        if (authenticate) {
            jmxEnv.put("jmx.remote.x.password.file", passwordFile);
            jmxEnv.put("jmx.remote.x.access.file", accessFile);
        }
        LocateRegistry.createRegistry(rmiRegistryPort);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JMXServiceURL serviceUrl = JMXListener.buildJMXServiceURL(rmiRegistryPort, rmiConnectorPort);
        try {
            this.jmxCS = JMXConnectorServerFactory.newJMXConnectorServer(serviceUrl, jmxEnv, mbs);
            this.jmxCS.start();
            LOG.info("ConnectorServer started!");
        }
        catch (IOException e) {
            LOG.error("fail to start connector server!", e);
        }
    }

    public void stopConnectorServer() throws IOException {
        if (this.jmxCS != null) {
            this.jmxCS.stop();
            LOG.info("ConnectorServer stopped!");
            this.jmxCS = null;
        }
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        int rmiRegistryPort = -1;
        int rmiConnectorPort = -1;
        Configuration conf = env.getConfiguration();
        if (env instanceof MasterCoprocessorEnvironment) {
            rmiRegistryPort = conf.getInt("master.rmi.registry.port", defMasterRMIRegistryPort);
            rmiConnectorPort = conf.getInt("master.rmi.connector.port", rmiRegistryPort);
            LOG.info("Master rmiRegistryPort:" + rmiRegistryPort + ",Master rmiConnectorPort:" + rmiConnectorPort);
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            rmiRegistryPort = conf.getInt("regionserver.rmi.registry.port", defRegionserverRMIRegistryPort);
            rmiConnectorPort = conf.getInt("regionserver.rmi.connector.port", rmiRegistryPort);
            LOG.info("RegionServer rmiRegistryPort:" + rmiRegistryPort + ",RegionServer rmiConnectorPort:" + rmiConnectorPort);
        } else if (env instanceof RegionCoprocessorEnvironment) {
            LOG.error("JMXListener should not be loaded in Region Environment!");
        }
        this.startConnectorServer(rmiRegistryPort, rmiConnectorPort);
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
        this.stopConnectorServer();
    }
}

