/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"UNKNOWN"}, justification="Findbugs doesn't like the way we are negating the result of a compare in below")
public class CellComparator
implements Comparator<Cell>,
Serializable {
    private static final long serialVersionUID = -8760041766259623329L;

    @Override
    public int compare(Cell a, Cell b) {
        return CellComparator.compareStatic(a, b);
    }

    public static int compareStatic(Cell a, Cell b) {
        return CellComparator.compareStatic(a, b, false);
    }

    public static int compareStatic(Cell a, Cell b, boolean onlyKey) {
        int c = Bytes.compareTo(a.getRowArray(), a.getRowOffset(), a.getRowLength(), b.getRowArray(), b.getRowOffset(), b.getRowLength());
        if (c != 0) {
            return c;
        }
        if (a.getFamilyLength() == 0 && a.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (b.getFamilyLength() == 0 && b.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        c = Bytes.compareTo(a.getFamilyArray(), a.getFamilyOffset(), a.getFamilyLength(), b.getFamilyArray(), b.getFamilyOffset(), b.getFamilyLength());
        if (c != 0) {
            return c;
        }
        c = Bytes.compareTo(a.getQualifierArray(), a.getQualifierOffset(), a.getQualifierLength(), b.getQualifierArray(), b.getQualifierOffset(), b.getQualifierLength());
        if (c != 0) {
            return c;
        }
        c = Longs.compare(b.getTimestamp(), a.getTimestamp());
        if (c != 0) {
            return c;
        }
        c = (0xFF & b.getTypeByte()) - (0xFF & a.getTypeByte());
        if (c != 0) {
            return c;
        }
        if (onlyKey) {
            return c;
        }
        return Longs.compare(b.getMvccVersion(), a.getMvccVersion());
    }

    public static boolean equals(Cell a, Cell b) {
        return CellComparator.equalsRow(a, b) && CellComparator.equalsFamily(a, b) && CellComparator.equalsQualifier(a, b) && CellComparator.equalsTimestamp(a, b) && CellComparator.equalsType(a, b);
    }

    public static boolean equalsRow(Cell a, Cell b) {
        return Bytes.equals(a.getRowArray(), a.getRowOffset(), a.getRowLength(), b.getRowArray(), b.getRowOffset(), b.getRowLength());
    }

    public static boolean equalsFamily(Cell a, Cell b) {
        return Bytes.equals(a.getFamilyArray(), a.getFamilyOffset(), a.getFamilyLength(), b.getFamilyArray(), b.getFamilyOffset(), b.getFamilyLength());
    }

    public static boolean equalsQualifier(Cell a, Cell b) {
        return Bytes.equals(a.getQualifierArray(), a.getQualifierOffset(), a.getQualifierLength(), b.getQualifierArray(), b.getQualifierOffset(), b.getQualifierLength());
    }

    public static boolean equalsTimestamp(Cell a, Cell b) {
        return a.getTimestamp() == b.getTimestamp();
    }

    public static boolean equalsType(Cell a, Cell b) {
        return a.getTypeByte() == b.getTypeByte();
    }

    public static int hashCode(Cell cell) {
        if (cell == null) {
            return 0;
        }
        int rowHash = Bytes.hashCode(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
        int familyHash = Bytes.hashCode(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
        int qualifierHash = Bytes.hashCode(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        int hash = 31 * rowHash + familyHash;
        hash = 31 * hash + qualifierHash;
        hash = 31 * hash + (int)cell.getTimestamp();
        hash = 31 * hash + cell.getTypeByte();
        hash = 31 * hash + (int)cell.getMvccVersion();
        return hash;
    }

    public static boolean areKeyLengthsEqual(Cell a, Cell b) {
        return a.getRowLength() == b.getRowLength() && a.getFamilyLength() == b.getFamilyLength() && a.getQualifierLength() == b.getQualifierLength();
    }

    public static boolean areRowLengthsEqual(Cell a, Cell b) {
        return a.getRowLength() == b.getRowLength();
    }

    private static int compareStaticIgnoreMvccVersion(Cell a, Cell b) {
        int c = Bytes.compareTo(a.getRowArray(), a.getRowOffset(), a.getRowLength(), b.getRowArray(), b.getRowOffset(), b.getRowLength());
        if (c != 0) {
            return c;
        }
        c = Bytes.compareTo(a.getFamilyArray(), a.getFamilyOffset(), a.getFamilyLength(), b.getFamilyArray(), b.getFamilyOffset(), b.getFamilyLength());
        if (c != 0) {
            return c;
        }
        c = Bytes.compareTo(a.getQualifierArray(), a.getQualifierOffset(), a.getQualifierLength(), b.getQualifierArray(), b.getQualifierOffset(), b.getQualifierLength());
        if (c != 0) {
            return c;
        }
        c = Longs.compare(b.getTimestamp(), a.getTimestamp());
        if (c != 0) {
            return c;
        }
        c = (0xFF & b.getTypeByte()) - (0xFF & a.getTypeByte());
        return c;
    }

    public static boolean equalsIgnoreMvccVersion(Cell a, Cell b) {
        return 0 == CellComparator.compareStaticIgnoreMvccVersion(a, b);
    }
}

