/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;

public class SimpleScalarValueChecker
implements RealConvergenceChecker {
    private static final double DEFAULT_RELATIVE_THRESHOLD = (double)1.110223E-14f;
    private static final double DEFAULT_ABSOLUTE_THRESHOLD = 2.2250738585072014E-306;
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public SimpleScalarValueChecker() {
        this.relativeThreshold = 1.110223E-14f;
        this.absoluteThreshold = 2.2250738585072014E-306;
    }

    public SimpleScalarValueChecker(double relativeThreshold, double absoluteThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.absoluteThreshold = absoluteThreshold;
    }

    public boolean converged(int iteration, RealPointValuePair previous, RealPointValuePair current) {
        double size2;
        double c;
        double p = previous.getValue();
        double difference = Math.abs(p - (c = current.getValue()));
        return difference <= (size2 = Math.max(Math.abs(p), Math.abs(c))) * this.relativeThreshold || difference <= this.absoluteThreshold;
    }
}

