/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.SparseFieldMatrix;
import org.apache.commons.math.util.OpenIntToFieldHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7841233292190413362L;
    private final Field<T> field;
    private final OpenIntToFieldHashMap<T> entries;
    private final int virtualSize;

    public SparseFieldVector(Field<T> field2) {
        this(field2, 0);
    }

    public SparseFieldVector(Field<T> field2, int dimension) {
        this.field = field2;
        this.virtualSize = dimension;
        this.entries = new OpenIntToFieldHashMap<T>(field2);
    }

    protected SparseFieldVector(SparseFieldVector<T> v, int resize2) {
        this.field = v.field;
        this.virtualSize = v.getDimension() + resize2;
        this.entries = new OpenIntToFieldHashMap<T>(v.entries);
    }

    public SparseFieldVector(Field<T> field2, int dimension, int expectedSize) {
        this.field = field2;
        this.virtualSize = dimension;
        this.entries = new OpenIntToFieldHashMap<T>(field2, expectedSize);
    }

    public SparseFieldVector(Field<T> field2, T[] values) {
        this.field = field2;
        this.virtualSize = values.length;
        this.entries = new OpenIntToFieldHashMap<T>(field2);
        for (int key = 0; key < values.length; ++key) {
            T value2 = values[key];
            this.entries.put(key, value2);
        }
    }

    public SparseFieldVector(SparseFieldVector<T> v) {
        this.field = v.field;
        this.virtualSize = v.getDimension();
        this.entries = new OpenIntToFieldHashMap<T>(super.getEntries());
    }

    private OpenIntToFieldHashMap<T> getEntries() {
        return this.entries;
    }

    @Override
    public FieldVector<T> add(SparseFieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        SparseFieldVector res = (SparseFieldVector)this.copy();
        OpenIntToFieldHashMap.Iterator iter2 = super.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            Object value2 = iter2.value();
            if (this.entries.containsKey(key)) {
                res.setEntry(key, (FieldElement)this.entries.get(key).add(value2));
                continue;
            }
            res.setEntry(key, value2);
        }
        return res;
    }

    @Override
    public FieldVector<T> add(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this.field, this.getDimension());
        for (int i = 0; i < v.length; ++i) {
            res.setEntry(i, (FieldElement)v[i].add(this.getEntry(i)));
        }
        return res;
    }

    @Override
    public FieldVector<T> append(SparseFieldVector<T> v) {
        SparseFieldVector res = new SparseFieldVector(this, v.getDimension());
        OpenIntToFieldHashMap.Iterator iter2 = v.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key() + this.virtualSize, iter2.value());
        }
        return res;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> v) {
        if (v instanceof SparseFieldVector) {
            return this.append((T)((SparseFieldVector)v));
        }
        return this.append((T)v.toArray());
    }

    @Override
    public FieldVector<T> append(T d) {
        SparseFieldVector<T> res = new SparseFieldVector<T>(this, 1);
        res.setEntry(this.virtualSize, d);
        return res;
    }

    @Override
    public FieldVector<T> append(T[] a) {
        SparseFieldVector<T> res = new SparseFieldVector<T>(this, a.length);
        for (int i = 0; i < a.length; ++i) {
            res.setEntry(i + this.virtualSize, a[i]);
        }
        return res;
    }

    @Override
    public FieldVector<T> copy() {
        return new SparseFieldVector<T>(this);
    }

    @Override
    public T dotProduct(FieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        FieldElement res = (FieldElement)this.field.getZero();
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res = (FieldElement)res.add(v.getEntry(iter2.key()).multiply(iter2.value()));
        }
        return (T)res;
    }

    @Override
    public T dotProduct(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        FieldElement res = (FieldElement)this.field.getZero();
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            int idx = iter2.key();
            FieldElement value2 = (FieldElement)this.field.getZero();
            if (idx < v.length) {
                value2 = v[idx];
            }
            res = (FieldElement)res.add(value2.multiply(iter2.value()));
        }
        return (T)res;
    }

    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), (FieldElement)iter2.value().divide(v.getEntry(iter2.key())));
        }
        return res;
    }

    @Override
    public FieldVector<T> ebeDivide(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), (FieldElement)iter2.value().divide(v[iter2.key()]));
        }
        return res;
    }

    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), (FieldElement)iter2.value().multiply(v.getEntry(iter2.key())));
        }
        return res;
    }

    @Override
    public FieldVector<T> ebeMultiply(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iter2 = res.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res.setEntry(iter2.key(), (FieldElement)iter2.value().multiply(v[iter2.key()]));
        }
        return res;
    }

    @Override
    public T[] getData() {
        FieldElement[] res = this.buildArray(this.virtualSize);
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            res[iter2.key()] = iter2.value();
        }
        return res;
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    @Override
    public T getEntry(int index2) throws MatrixIndexException {
        this.checkIndex(index2);
        return this.entries.get(index2);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> getSubVector(int index2, int n) throws MatrixIndexException {
        this.checkIndex(index2);
        this.checkIndex(index2 + n - 1);
        SparseFieldVector res = new SparseFieldVector(this.field, n);
        int end = index2 + n;
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (key < index2 || key >= end) continue;
            res.setEntry(key - index2, iter2.value());
        }
        return res;
    }

    @Override
    public FieldVector<T> mapAdd(T d) {
        return this.copy().mapAddToSelf(d);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T d) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, (FieldElement)this.getEntry(i).add(d));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T d) {
        return this.copy().mapDivideToSelf(d);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T d) {
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            this.entries.put(iter2.key(), (FieldElement)iter2.value().divide(d));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() {
        return this.copy().mapInvToSelf();
    }

    @Override
    public FieldVector<T> mapInvToSelf() {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, (FieldElement)((FieldElement)this.field.getOne()).divide(this.getEntry(i)));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T d) {
        return this.copy().mapMultiplyToSelf(d);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T d) {
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            this.entries.put(iter2.key(), (FieldElement)iter2.value().multiply(d));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T d) {
        return this.copy().mapSubtractToSelf(d);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T d) {
        return this.mapAddToSelf((FieldElement)((FieldElement)this.field.getZero()).subtract(d));
    }

    @Override
    public FieldMatrix<T> outerProduct(SparseFieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        SparseFieldMatrix<FieldElement> res = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, this.virtualSize);
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            OpenIntToFieldHashMap.Iterator iter22 = v.entries.iterator();
            while (iter22.hasNext()) {
                iter22.advance();
                res.setEntry(iter2.key(), iter22.key(), (FieldElement)iter2.value().multiply(iter22.value()));
            }
        }
        return res;
    }

    @Override
    public FieldMatrix<T> outerProduct(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        SparseFieldMatrix<FieldElement> res = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, this.virtualSize);
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int row = iter2.key();
            T value2 = iter2.value();
            for (int col = 0; col < this.virtualSize; ++col) {
                res.setEntry(row, col, (FieldElement)value2.multiply(v[col]));
            }
        }
        return res;
    }

    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> v) throws IllegalArgumentException {
        if (v instanceof SparseFieldVector) {
            return this.outerProduct((SparseFieldVector)v);
        }
        return this.outerProduct(v.toArray());
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        return v.mapMultiply((FieldElement)this.dotProduct(v).divide(v.dotProduct(v)));
    }

    @Override
    public FieldVector<T> projection(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        return this.projection(new SparseFieldVector(this.field, v));
    }

    @Override
    public void set(T value2) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, value2);
        }
    }

    @Override
    public void setEntry(int index2, T value2) throws MatrixIndexException {
        this.checkIndex(index2);
        this.entries.put(index2, value2);
    }

    @Override
    public void setSubVector(int index2, FieldVector<T> v) throws MatrixIndexException {
        this.checkIndex(index2);
        this.checkIndex(index2 + v.getDimension() - 1);
        this.setSubVector(index2, v.getData());
    }

    @Override
    public void setSubVector(int index2, T[] v) throws MatrixIndexException {
        this.checkIndex(index2);
        this.checkIndex(index2 + v.length - 1);
        for (int i = 0; i < v.length; ++i) {
            this.setEntry(i + index2, v[i]);
        }
    }

    @Override
    public SparseFieldVector<T> subtract(SparseFieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
        SparseFieldVector res = (SparseFieldVector)this.copy();
        OpenIntToFieldHashMap.Iterator iter2 = super.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int key = iter2.key();
            if (this.entries.containsKey(key)) {
                res.setEntry(key, (FieldElement)this.entries.get(key).subtract(iter2.value()));
                continue;
            }
            res.setEntry(key, (FieldElement)((FieldElement)this.field.getZero()).subtract(iter2.value()));
        }
        return res;
    }

    @Override
    public FieldVector<T> subtract(FieldVector<T> v) throws IllegalArgumentException {
        if (v instanceof SparseFieldVector) {
            return this.subtract((SparseFieldVector)v);
        }
        return this.subtract(v.toArray());
    }

    @Override
    public FieldVector<T> subtract(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        SparseFieldVector<FieldElement> res = new SparseFieldVector<FieldElement>(this);
        for (int i = 0; i < v.length; ++i) {
            if (this.entries.containsKey(i)) {
                res.setEntry(i, (FieldElement)this.entries.get(i).subtract(v[i]));
                continue;
            }
            res.setEntry(i, (FieldElement)((FieldElement)this.field.getZero()).subtract(v[i]));
        }
        return res;
    }

    @Override
    public T[] toArray() {
        return this.getData();
    }

    private void checkIndex(int index2) throws MatrixIndexException {
        if (index2 < 0 || index2 >= this.getDimension()) {
            throw new MatrixIndexException("index {0} out of allowed range [{1}, {2}]", index2, 0, this.getDimension() - 1);
        }
    }

    protected void checkVectorDimensions(int n) throws IllegalArgumentException {
        if (this.getDimension() != n) {
            throw MathRuntimeException.createIllegalArgumentException("vector length mismatch: got {0} but expected {1}", this.getDimension(), n);
        }
    }

    @Override
    public FieldVector<T> add(FieldVector<T> v) throws IllegalArgumentException {
        if (v instanceof SparseFieldVector) {
            return this.add((SparseFieldVector)v);
        }
        return this.add(v.toArray());
    }

    private T[] buildArray(int length) {
        return (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), length);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.field == null ? 0 : this.field.hashCode());
        result2 = 31 * result2 + this.virtualSize;
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            int temp = iter2.value().hashCode();
            result2 = 31 * result2 + temp;
        }
        return result2;
    }

    public boolean equals(Object obj) {
        T test;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparseFieldVector)) {
            return false;
        }
        SparseFieldVector other = (SparseFieldVector)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.virtualSize != other.virtualSize) {
            return false;
        }
        OpenIntToFieldHashMap.Iterator iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            test = other.getEntry(iter2.key());
            if (test.equals(iter2.value())) continue;
            return false;
        }
        iter2 = other.getEntries().iterator();
        while (iter2.hasNext()) {
            iter2.advance();
            test = iter2.value();
            if (test.equals(this.getEntry(iter2.key()))) continue;
            return false;
        }
        return true;
    }
}

