/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.util.MathUtils;

public class MullerSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public MullerSolver(UnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    public MullerSolver() {
        super(100, 1.0E-6);
    }

    @Deprecated
    public double solve(double min2, double max2) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, min2, max2);
    }

    @Deprecated
    public double solve(double min2, double max2, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, min2, max2, initial);
    }

    public double solve(UnivariateRealFunction f, double min2, double max2, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        if (f.value(min2) == 0.0) {
            return min2;
        }
        if (f.value(max2) == 0.0) {
            return max2;
        }
        if (f.value(initial) == 0.0) {
            return initial;
        }
        this.verifyBracketing(min2, max2, f);
        this.verifySequence(min2, initial, max2);
        if (this.isBracketing(min2, initial, f)) {
            return this.solve(f, min2, initial);
        }
        return this.solve(f, initial, max2);
    }

    public double solve(UnivariateRealFunction f, double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException {
        double x0 = min2;
        double y0 = f.value(x0);
        double x2 = max2;
        double y2 = f.value(x2);
        double x1 = 0.5 * (x0 + x2);
        double y1 = f.value(x1);
        if (y0 == 0.0) {
            return min2;
        }
        if (y2 == 0.0) {
            return max2;
        }
        this.verifyBracketing(min2, max2, f);
        double oldx = Double.POSITIVE_INFINITY;
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            boolean bisect;
            double d01 = (y1 - y0) / (x1 - x0);
            double d12 = (y2 - y1) / (x2 - x1);
            double d012 = (d12 - d01) / (x2 - x0);
            double c1 = d01 + (x1 - x0) * d012;
            double delta = c1 * c1 - 4.0 * y1 * d012;
            double xplus = x1 + -2.0 * y1 / (c1 + Math.sqrt(delta));
            double xminus = x1 + -2.0 * y1 / (c1 - Math.sqrt(delta));
            double x = this.isSequence(x0, xplus, x2) ? xplus : xminus;
            double y = f.value(x);
            double tolerance = Math.max(this.relativeAccuracy * Math.abs(x), this.absoluteAccuracy);
            if (Math.abs(x - oldx) <= tolerance) {
                this.setResult(x, i);
                return this.result;
            }
            if (Math.abs(y) <= this.functionValueAccuracy) {
                this.setResult(x, i);
                return this.result;
            }
            boolean bl = bisect = x < x1 && x1 - x0 > 0.95 * (x2 - x0) || x > x1 && x2 - x1 > 0.95 * (x2 - x0) || x == x1;
            if (!bisect) {
                x0 = x < x1 ? x0 : x1;
                y0 = x < x1 ? y0 : y1;
                x2 = x > x1 ? x2 : x1;
                y2 = x > x1 ? y2 : y1;
                x1 = x;
                y1 = y;
                oldx = x;
                continue;
            }
            double xm = 0.5 * (x0 + x2);
            double ym = f.value(xm);
            if (MathUtils.sign(y0) + MathUtils.sign(ym) == 0.0) {
                x2 = xm;
                y2 = ym;
            } else {
                x0 = xm;
                y0 = ym;
            }
            x1 = 0.5 * (x0 + x2);
            y1 = f.value(x1);
            oldx = Double.POSITIVE_INFINITY;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    @Deprecated
    public double solve2(double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve2(this.f, min2, max2);
    }

    public double solve2(UnivariateRealFunction f, double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException {
        double x0 = min2;
        double y0 = f.value(x0);
        double x1 = max2;
        double y1 = f.value(x1);
        double x2 = 0.5 * (x0 + x1);
        double y2 = f.value(x2);
        if (y0 == 0.0) {
            return min2;
        }
        if (y1 == 0.0) {
            return max2;
        }
        this.verifyBracketing(min2, max2, f);
        double oldx = Double.POSITIVE_INFINITY;
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double x;
            double denominator;
            double q = (x2 - x1) / (x1 - x0);
            double b = (2.0 * q + 1.0) * y2 - (1.0 + q) * (1.0 + q) * y1 + q * q * y0;
            double a = q * (y2 - (1.0 + q) * y1 + q * y0);
            double c = (1.0 + q) * y2;
            double delta = b * b - 4.0 * a * c;
            if (delta >= 0.0) {
                double dplus = b + Math.sqrt(delta);
                double dminus = b - Math.sqrt(delta);
                denominator = Math.abs(dplus) > Math.abs(dminus) ? dplus : dminus;
            } else {
                denominator = Math.sqrt(b * b - delta);
            }
            if (denominator != 0.0) {
                for (x = x2 - 2.0 * c * (x2 - x1) / denominator; x == x1 || x == x2; x += this.absoluteAccuracy) {
                }
            } else {
                x = min2 + Math.random() * (max2 - min2);
                oldx = Double.POSITIVE_INFINITY;
            }
            double y = f.value(x);
            double tolerance = Math.max(this.relativeAccuracy * Math.abs(x), this.absoluteAccuracy);
            if (Math.abs(x - oldx) <= tolerance) {
                this.setResult(x, i);
                return this.result;
            }
            if (Math.abs(y) <= this.functionValueAccuracy) {
                this.setResult(x, i);
                return this.result;
            }
            x0 = x1;
            y0 = y1;
            x1 = x2;
            y1 = y2;
            x2 = x;
            y2 = y;
            oldx = x;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

