/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;

public class TrapezoidIntegrator
extends UnivariateRealIntegratorImpl {
    private double s;

    @Deprecated
    public TrapezoidIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    public TrapezoidIntegrator() {
        super(64);
    }

    double stage(UnivariateRealFunction f, double min2, double max2, int n) throws FunctionEvaluationException {
        if (n == 0) {
            this.s = 0.5 * (max2 - min2) * (f.value(min2) + f.value(max2));
            return this.s;
        }
        long np = 1L << n - 1;
        double sum2 = 0.0;
        double spacing = (max2 - min2) / (double)np;
        double x = min2 + 0.5 * spacing;
        for (long i = 0L; i < np; ++i) {
            sum2 += f.value(x);
            x += spacing;
        }
        this.s = 0.5 * (this.s + sum2 * spacing);
        return this.s;
    }

    @Deprecated
    public double integrate(double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min2, max2);
    }

    public double integrate(UnivariateRealFunction f, double min2, double max2) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min2, max2);
        this.verifyIterationCount();
        double oldt = this.stage(f, min2, max2, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double rLimit;
            double delta;
            double t = this.stage(f, min2, max2, i);
            if (i >= this.minimalIterationCount && ((delta = Math.abs(t - oldt)) <= (rLimit = this.relativeAccuracy * (Math.abs(oldt) + Math.abs(t)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(t, i);
                return this.result;
            }
            oldt = t;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw MathRuntimeException.createIllegalArgumentException("invalid iteration limits: min={0}, max={1}", 0, 64);
        }
    }
}

