/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MathException
extends Exception {
    private static final long serialVersionUID = -9004610152740737812L;
    private final String pattern;
    private final Object[] arguments;

    public MathException() {
        this.pattern = null;
        this.arguments = new Object[0];
    }

    public MathException(String pattern, Object ... arguments) {
        this.pattern = pattern;
        this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
    }

    public MathException(Throwable rootCause) {
        super(rootCause);
        this.pattern = this.getMessage();
        this.arguments = new Object[0];
    }

    public MathException(Throwable rootCause, String pattern, Object ... arguments) {
        super(rootCause);
        this.pattern = pattern;
        this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
    }

    private static String translate(String s2, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.apache.commons.math.MessagesResources", locale);
            if (bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return bundle.getString(s2);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return s2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return this.pattern == null ? "" : new MessageFormat(MathException.translate(this.pattern, locale), locale).format(this.arguments);
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }
}

