/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingUtil {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$util$EncodingUtil == null ? (class$org$apache$commons$httpclient$util$EncodingUtil = EncodingUtil.class$("org.apache.commons.httpclient.util.EncodingUtil")) : class$org$apache$commons$httpclient$util$EncodingUtil);
    static /* synthetic */ Class class$org$apache$commons$httpclient$util$EncodingUtil;

    public static String formUrlEncode(NameValuePair[] pairs, String charset) {
        try {
            return EncodingUtil.doFormUrlEncode(pairs, charset);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding not supported: " + charset);
            try {
                return EncodingUtil.doFormUrlEncode(pairs, DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException fatal) {
                throw new HttpClientError("Encoding not supported: ISO-8859-1");
            }
        }
    }

    private static String doFormUrlEncode(NameValuePair[] pairs, String charset) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pairs.length; ++i) {
            URLCodec codec = new URLCodec();
            NameValuePair pair2 = pairs[i];
            if (pair2.getName() == null) continue;
            if (i > 0) {
                buf.append("&");
            }
            buf.append(codec.encode(pair2.getName(), charset));
            buf.append("=");
            if (pair2.getValue() == null) continue;
            buf.append(codec.encode(pair2.getValue(), charset));
        }
        return buf.toString();
    }

    public static String getString(byte[] data2, int offset, int length, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(data2, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + charset + ". System encoding used");
            }
            return new String(data2, offset, length);
        }
    }

    public static String getString(byte[] data2, String charset) {
        return EncodingUtil.getString(data2, 0, data2.length, charset);
    }

    public static byte[] getBytes(String data2, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data2.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + charset + ". System encoding used.");
            }
            return data2.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data2.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data2, int offset, int length) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data2, offset, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data2) {
        return EncodingUtil.getAsciiString(data2, 0, data2.length);
    }

    private EncodingUtil() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

