/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringPart
extends PartBase {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$methods$multipart$StringPart == null ? (class$org$apache$commons$httpclient$methods$multipart$StringPart = StringPart.class$("org.apache.commons.httpclient.methods.multipart.StringPart")) : class$org$apache$commons$httpclient$methods$multipart$StringPart);
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_CHARSET = "US-ASCII";
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private byte[] content;
    private String value;
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$multipart$StringPart;

    public StringPart(String name, String value2, String charset) {
        super(name, DEFAULT_CONTENT_TYPE, charset == null ? DEFAULT_CHARSET : charset, DEFAULT_TRANSFER_ENCODING);
        if (value2 == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (value2.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.value = value2;
    }

    public StringPart(String name, String value2) {
        this(name, value2, null);
    }

    private byte[] getContent() {
        if (this.content == null) {
            this.content = EncodingUtil.getBytes(this.value, this.getCharSet());
        }
        return this.content;
    }

    protected void sendData(OutputStream out) throws IOException {
        LOG.trace("enter sendData(OutputStream)");
        out.write(this.getContent());
    }

    protected long lengthOfData() throws IOException {
        LOG.trace("enter lengthOfData()");
        return this.getContent().length;
    }

    public void setCharSet(String charSet) {
        super.setCharSet(charSet);
        this.content = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

