/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConstants {
    public static final String HTTP_ELEMENT_CHARSET = "US-ASCII";
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$HttpConstants == null ? (class$org$apache$commons$httpclient$HttpConstants = HttpConstants.class$("org.apache.commons.httpclient.HttpConstants")) : class$org$apache$commons$httpclient$HttpConstants);
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpConstants;

    public static byte[] getBytes(String data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data2.getBytes(HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: US-ASCII. System default encoding used");
            }
            return data2.getBytes();
        }
    }

    public static String getString(byte[] data2, int offset, int length) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data2, offset, length, HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: US-ASCII. System default encoding used");
            }
            return new String(data2, offset, length);
        }
    }

    public static String getString(byte[] data2) {
        return HttpConstants.getString(data2, 0, data2.length);
    }

    public static byte[] getContentBytes(String data2, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.equals("")) {
            charset = DEFAULT_CONTENT_CHARSET;
        }
        try {
            return data2.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + charset + ". HTTP default encoding used");
            }
            try {
                return data2.getBytes(DEFAULT_CONTENT_CHARSET);
            }
            catch (UnsupportedEncodingException e2) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unsupported encoding: ISO-8859-1. System encoding used");
                }
                return data2.getBytes();
            }
        }
    }

    public static String getContentString(byte[] data2, int offset, int length, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.equals("")) {
            charset = DEFAULT_CONTENT_CHARSET;
        }
        try {
            return new String(data2, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + charset + ". Default HTTP encoding used");
            }
            try {
                return new String(data2, offset, length, DEFAULT_CONTENT_CHARSET);
            }
            catch (UnsupportedEncodingException e2) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unsupported encoding: ISO-8859-1. System encoding used");
                }
                return new String(data2, offset, length);
            }
        }
    }

    public static String getContentString(byte[] data2, String charset) {
        return HttpConstants.getContentString(data2, 0, data2.length, charset);
    }

    public static byte[] getContentBytes(String data2) {
        return HttpConstants.getContentBytes(data2, null);
    }

    public static String getContentString(byte[] data2, int offset, int length) {
        return HttpConstants.getContentString(data2, offset, length, null);
    }

    public static String getContentString(byte[] data2) {
        return HttpConstants.getContentString(data2, null);
    }

    public static byte[] getAsciiBytes(String data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data2.getBytes(HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data2, int offset, int length) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data2, offset, length, HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data2) {
        return HttpConstants.getAsciiString(data2, 0, data2.length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

