/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.beanutils.ConfigurationDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationDynaBean
extends ConfigurationMap
implements DynaBean {
    private static final String PROPERTY_DELIMITER = ".";
    private static Log log = LogFactory.getLog(class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean == null ? (class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean = ConfigurationDynaBean.class$("org.apache.commons.configuration.beanutils.ConfigurationDynaBean")) : class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean);
    static /* synthetic */ Class class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean;

    public ConfigurationDynaBean(Configuration configuration) {
        super(configuration);
        if (log.isTraceEnabled()) {
            log.trace("ConfigurationDynaBean(" + configuration + ")");
        }
    }

    public void set(String name, Object value2) {
        if (log.isTraceEnabled()) {
            log.trace("set(" + name + "," + value2 + ")");
        }
        if (value2 == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                this.getConfiguration().addProperty(name, iterator2.next());
            }
        } else if (value2.getClass().isArray()) {
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                this.getConfiguration().addProperty(name, Array.get(value2, i));
            }
        } else {
            this.getConfiguration().setProperty(name, value2);
        }
    }

    public Object get(String name) {
        SubsetConfiguration subset;
        Object result2;
        if (log.isTraceEnabled()) {
            log.trace("get(" + name + ")");
        }
        if ((result2 = this.getConfiguration().getProperty(name)) == null && !(subset = new SubsetConfiguration(this.getConfiguration(), name, PROPERTY_DELIMITER)).isEmpty()) {
            result2 = new ConfigurationDynaBean(subset);
        }
        if (log.isDebugEnabled()) {
            log.debug(name + "=[" + result2 + "]");
        }
        if (result2 == null) {
            throw new IllegalArgumentException("Property '" + name + "' does not exist.");
        }
        return result2;
    }

    public boolean contains(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.containsKey(key);
    }

    public Object get(String name, int index2) {
        try {
            List list2 = this.getConfiguration().getList(name);
            if (list2.isEmpty()) {
                throw new IllegalArgumentException("Indexed property '" + name + "' does not exist.");
            }
            return list2.get(index2);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
    }

    public Object get(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.getProperty(key);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.getConfiguration());
    }

    public void remove(String name, String key) {
        SubsetConfiguration subset = new SubsetConfiguration(this.getConfiguration(), name, PROPERTY_DELIMITER);
        subset.setProperty(key, null);
    }

    public void set(String name, int index2, Object value2) {
        block6: {
            try {
                Object property = this.getConfiguration().getProperty(name);
                if (property == null) {
                    throw new IllegalArgumentException("Property '" + name + "' does not exist.");
                }
                if (property instanceof List) {
                    List list2 = (List)property;
                    list2.set(index2, value2);
                    this.getConfiguration().setProperty(name, list2);
                    break block6;
                }
                if (property.getClass().isArray()) {
                    Array.set(property, index2, value2);
                    break block6;
                }
                if (index2 == 0) {
                    this.getConfiguration().setProperty(name, value2);
                    break block6;
                }
                throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
            }
        }
    }

    public void set(String name, String key, Object value2) {
        this.getConfiguration().setProperty(name + PROPERTY_DELIMITER + key, value2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

