/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import org.apache.commons.lang.ClassUtils;

public class BeanHelper {
    private static Map beanFactories = Collections.synchronizedMap(new HashMap());
    private static BeanFactory defaultBeanFactory = DefaultBeanFactory.INSTANCE;

    private BeanHelper() {
    }

    public static void registerBeanFactory(String name, BeanFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name for bean factory must not be null!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Bean factory must not be null!");
        }
        beanFactories.put(name, factory);
    }

    public static BeanFactory deregisterBeanFactory(String name) {
        return (BeanFactory)beanFactories.remove(name);
    }

    public static Set registeredFactoryNames() {
        return beanFactories.keySet();
    }

    public static BeanFactory getDefaultBeanFactory() {
        return defaultBeanFactory;
    }

    public static void setDefaultBeanFactory(BeanFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Default bean factory must not be null!");
        }
        defaultBeanFactory = factory;
    }

    public static void initBean(Object bean, BeanDeclaration data2) throws ConfigurationRuntimeException {
        Map nestedBeans;
        Map properties = data2.getBeanProperties();
        if (properties != null) {
            Iterator it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String propName = (String)e.getKey();
                BeanHelper.initProperty(bean, propName, e.getValue());
            }
        }
        if ((nestedBeans = data2.getNestedBeanDeclarations()) != null) {
            Iterator it = nestedBeans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String propName = (String)e.getKey();
                BeanHelper.initProperty(bean, propName, BeanHelper.createBean((BeanDeclaration)e.getValue(), null));
            }
        }
    }

    private static void initProperty(Object bean, String propName, Object value2) throws ConfigurationRuntimeException {
        if (!PropertyUtils.isWriteable(bean, propName)) {
            throw new ConfigurationRuntimeException("Property " + propName + " cannot be set!");
        }
        try {
            BeanUtils.setProperty(bean, propName, value2);
        }
        catch (IllegalAccessException iaex) {
            throw new ConfigurationRuntimeException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new ConfigurationRuntimeException(itex);
        }
    }

    public static Object createBean(BeanDeclaration data2, Class defaultClass, Object param2) throws ConfigurationRuntimeException {
        if (data2 == null) {
            throw new IllegalArgumentException("Bean declaration must not be null!");
        }
        BeanFactory factory = BeanHelper.fetchBeanFactory(data2);
        try {
            return factory.createBean(BeanHelper.fetchBeanClass(data2, defaultClass, factory), data2, param2);
        }
        catch (Exception ex) {
            throw new ConfigurationRuntimeException(ex);
        }
    }

    public static Object createBean(BeanDeclaration data2, Class defaultClass) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data2, defaultClass, null);
    }

    public static Object createBean(BeanDeclaration data2) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data2, null);
    }

    static Class loadClass(String name, Class callingClass) throws ClassNotFoundException {
        return ClassUtils.getClass(name);
    }

    private static Class fetchBeanClass(BeanDeclaration data2, Class defaultClass, BeanFactory factory) throws ConfigurationRuntimeException {
        String clsName = data2.getBeanClassName();
        if (clsName != null) {
            try {
                return BeanHelper.loadClass(clsName, factory.getClass());
            }
            catch (ClassNotFoundException cex) {
                throw new ConfigurationRuntimeException(cex);
            }
        }
        if (defaultClass != null) {
            return defaultClass;
        }
        Class clazz = factory.getDefaultBeanClass();
        if (clazz == null) {
            throw new ConfigurationRuntimeException("Bean class is not specified!");
        }
        return clazz;
    }

    private static BeanFactory fetchBeanFactory(BeanDeclaration data2) throws ConfigurationRuntimeException {
        String factoryName = data2.getBeanFactoryName();
        if (factoryName != null) {
            BeanFactory factory = (BeanFactory)beanFactories.get(factoryName);
            if (factory == null) {
                throw new ConfigurationRuntimeException("Unknown bean factory: " + factoryName);
            }
            return factory;
        }
        return BeanHelper.getDefaultBeanFactory();
    }
}

