/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleBeanUtilsBean
extends BeanUtilsBean {
    private static final ContextClassLoaderLocal localeBeansByClassLoader = new ContextClassLoaderLocal(){

        protected Object initialValue() {
            return new LocaleBeanUtilsBean();
        }
    };
    private static Log log = LogFactory.getLog(class$org$apache$commons$beanutils$locale$LocaleBeanUtilsBean == null ? (class$org$apache$commons$beanutils$locale$LocaleBeanUtilsBean = LocaleBeanUtilsBean.class$("org.apache.commons.beanutils.locale.LocaleBeanUtilsBean")) : class$org$apache$commons$beanutils$locale$LocaleBeanUtilsBean);
    private LocaleConvertUtilsBean localeConvertUtils;
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$LocaleBeanUtilsBean;

    public static synchronized LocaleBeanUtilsBean getLocaleBeanUtilsInstance() {
        return (LocaleBeanUtilsBean)localeBeansByClassLoader.get();
    }

    public static synchronized void setInstance(LocaleBeanUtilsBean newInstance) {
        localeBeansByClassLoader.set(newInstance);
    }

    public LocaleBeanUtilsBean() {
        this.localeConvertUtils = new LocaleConvertUtilsBean();
    }

    public LocaleBeanUtilsBean(LocaleConvertUtilsBean localeConvertUtils, ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        super(convertUtilsBean, propertyUtilsBean);
        this.localeConvertUtils = localeConvertUtils;
    }

    public LocaleBeanUtilsBean(LocaleConvertUtilsBean localeConvertUtils) {
        this.localeConvertUtils = localeConvertUtils;
    }

    public LocaleConvertUtilsBean getLocaleConvertUtils() {
        return this.localeConvertUtils;
    }

    public Locale getDefaultLocale() {
        return this.getLocaleConvertUtils().getDefaultLocale();
    }

    public void setDefaultLocale(Locale locale) {
        this.getLocaleConvertUtils().setDefaultLocale(locale);
    }

    public boolean getApplyLocalized() {
        return this.getLocaleConvertUtils().getApplyLocalized();
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.getLocaleConvertUtils().setApplyLocalized(newApplyLocalized);
    }

    public String getIndexedProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getIndexedProperty(bean, name);
        return this.getLocaleConvertUtils().convert(value2, pattern);
    }

    public String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getIndexedProperty(bean, name, null);
    }

    public String getIndexedProperty(Object bean, String name, int index2, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getIndexedProperty(bean, name, index2);
        return this.getLocaleConvertUtils().convert(value2, pattern);
    }

    public String getIndexedProperty(Object bean, String name, int index2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getIndexedProperty(bean, name, index2, null);
    }

    public String getSimpleProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getSimpleProperty(bean, name);
        return this.getLocaleConvertUtils().convert(value2, pattern);
    }

    public String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getSimpleProperty(bean, name, null);
    }

    public String getMappedProperty(Object bean, String name, String key, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getMappedProperty(bean, name, key);
        return this.getLocaleConvertUtils().convert(value2, pattern);
    }

    public String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getMappedProperty(bean, name, key, null);
    }

    public String getMappedPropertyLocale(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getMappedProperty(bean, name);
        return this.getLocaleConvertUtils().convert(value2, pattern);
    }

    public String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getMappedPropertyLocale(bean, name, null);
    }

    public String getNestedProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value2 = this.getPropertyUtils().getNestedProperty(bean, name);
        return this.getLocaleConvertUtils().convert(value2, pattern);
    }

    public String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name, null);
    }

    public String getProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name, pattern);
    }

    public String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public void setProperty(Object bean, String name, Object value2) throws IllegalAccessException, InvocationTargetException {
        this.setProperty(bean, name, value2, null);
    }

    public void setProperty(Object bean, String name, Object value2, String pattern) throws IllegalAccessException, InvocationTargetException {
        Class type;
        Descriptor propInfo;
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("  setProperty(");
            sb.append(bean);
            sb.append(", ");
            sb.append(name);
            sb.append(", ");
            if (value2 == null) {
                sb.append("<NULL>");
            } else if (value2 instanceof String) {
                sb.append((String)value2);
            } else if (value2 instanceof String[]) {
                String[] values = (String[])value2;
                sb.append('[');
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(values[i]);
                    ++i;
                }
                sb.append(']');
            } else {
                sb.append(value2.toString());
            }
            sb.append(')');
            log.trace(sb.toString());
        }
        if ((propInfo = this.calculate(bean, name)) != null && (type = this.definePropertyType(propInfo.getTarget(), name, propInfo.getPropName())) != null) {
            Object newValue = this.convert(type, propInfo.getIndex(), value2, pattern);
            this.invokeSetter(propInfo.getTarget(), propInfo.getPropName(), propInfo.getKey(), propInfo.getIndex(), newValue);
        }
    }

    protected Class definePropertyType(Object target, String name, String propName) throws IllegalAccessException, InvocationTargetException {
        Class<Object> type = null;
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return null;
            }
            type = dynaProperty.getType();
        } else {
            PropertyDescriptor descriptor = null;
            try {
                descriptor = this.getPropertyUtils().getPropertyDescriptor(target, name);
                if (descriptor == null) {
                    return null;
                }
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            type = descriptor instanceof MappedPropertyDescriptor ? ((MappedPropertyDescriptor)descriptor).getMappedPropertyType() : (descriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType() : descriptor.getPropertyType());
        }
        return type;
    }

    protected Object convert(Class type, int index2, Object value2, String pattern) {
        if (log.isTraceEnabled()) {
            log.trace("Converting value '" + value2 + "' to type:" + type);
        }
        Object newValue = null;
        if (type.isArray() && index2 < 0) {
            if (value2 instanceof String) {
                String[] values = new String[]{(String)value2};
                newValue = this.getLocaleConvertUtils().convert(values, type, pattern);
            } else {
                newValue = value2 instanceof String[] ? this.getLocaleConvertUtils().convert((String[])value2, type, pattern) : value2;
            }
        } else {
            newValue = type.isArray() ? (value2 instanceof String ? this.getLocaleConvertUtils().convert((String)value2, type.getComponentType(), pattern) : (value2 instanceof String[] ? this.getLocaleConvertUtils().convert(((String[])value2)[0], type.getComponentType(), pattern) : value2)) : (value2 instanceof String ? this.getLocaleConvertUtils().convert((String)value2, type, pattern) : (value2 instanceof String[] ? this.getLocaleConvertUtils().convert(((String[])value2)[0], type, pattern) : value2));
        }
        return newValue;
    }

    protected Object convert(Class type, int index2, Object value2) {
        Object newValue = null;
        if (type.isArray() && index2 < 0) {
            if (value2 instanceof String) {
                String[] values = new String[]{(String)value2};
                newValue = ConvertUtils.convert(values, type);
            } else {
                newValue = value2 instanceof String[] ? ConvertUtils.convert((String[])value2, type) : value2;
            }
        } else {
            newValue = type.isArray() ? (value2 instanceof String ? ConvertUtils.convert((String)value2, type.getComponentType()) : (value2 instanceof String[] ? ConvertUtils.convert(((String[])value2)[0], type.getComponentType()) : value2)) : (value2 instanceof String ? ConvertUtils.convert((String)value2, type) : (value2 instanceof String[] ? ConvertUtils.convert(((String[])value2)[0], type) : value2));
        }
        return newValue;
    }

    protected void invokeSetter(Object target, String propName, String key, int index2, Object newValue) throws IllegalAccessException, InvocationTargetException {
        try {
            if (index2 >= 0) {
                this.getPropertyUtils().setIndexedProperty(target, propName, index2, newValue);
            } else if (key != null) {
                this.getPropertyUtils().setMappedProperty(target, propName, key, newValue);
            } else {
                this.getPropertyUtils().setProperty(target, propName, newValue);
            }
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e, "Cannot set " + propName);
        }
    }

    protected Descriptor calculate(Object bean, String name) throws IllegalAccessException, InvocationTargetException {
        int j;
        int i;
        String propName = null;
        int index2 = -1;
        String key = null;
        Object target = bean;
        int delim = name.lastIndexOf(46);
        if (delim >= 0) {
            try {
                target = this.getPropertyUtils().getProperty(bean, name.substring(0, delim));
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            name = name.substring(delim + 1);
            if (log.isTraceEnabled()) {
                log.trace("    Target bean = " + target);
                log.trace("    Target name = " + name);
            }
        }
        if ((i = (propName = name).indexOf(91)) >= 0) {
            int k = propName.indexOf(93);
            try {
                index2 = Integer.parseInt(propName.substring(i + 1, k));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            propName = propName.substring(0, i);
        }
        if ((j = propName.indexOf(40)) >= 0) {
            int k = propName.indexOf(41);
            try {
                key = propName.substring(j + 1, k);
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            propName = propName.substring(0, j);
        }
        return new Descriptor(target, name, propName, key, index2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Descriptor {
        private int index = -1;
        private String name;
        private String propName;
        private String key;
        private Object target;

        public Descriptor(Object target, String name, String propName, String key, int index2) {
            this.setTarget(target);
            this.setName(name);
            this.setPropName(propName);
            this.setKey(key);
            this.setIndex(index2);
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index2) {
            this.index = index2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }
    }
}

