/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class ShortConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public ShortConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ShortConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value2 instanceof Short) {
            return value2;
        }
        if (value2 instanceof Number) {
            return new Short(((Number)value2).shortValue());
        }
        try {
            return new Short(value2.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

