/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class IntegerConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public IntegerConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public IntegerConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value2 instanceof Integer) {
            return value2;
        }
        if (value2 instanceof Number) {
            return new Integer(((Number)value2).intValue());
        }
        try {
            return new Integer(value2.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

