/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigInteger;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class BigIntegerConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public BigIntegerConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public BigIntegerConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value2) {
        if (value2 == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value2 instanceof BigInteger) {
            return value2;
        }
        try {
            return new BigInteger(value2.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

