/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

abstract class JDBCDynaClass
implements DynaClass,
Serializable {
    protected boolean lowerCase = true;
    protected DynaProperty[] properties = null;
    protected Map propertiesMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    JDBCDynaClass() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException("newInstance() not supported");
    }

    protected Class loadClass(String className) throws SQLException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return cl.loadClass(className);
        }
        catch (Exception e) {
            throw new SQLException("Cannot load column class '" + className + "': " + e);
        }
    }

    protected DynaProperty createDynaProperty(ResultSetMetaData metadata, int i) throws SQLException {
        Class clazz;
        String name = null;
        name = this.lowerCase ? metadata.getColumnName(i).toLowerCase() : metadata.getColumnName(i);
        String className = null;
        try {
            className = metadata.getColumnClassName(i);
        }
        catch (SQLException e) {
            // empty catch block
        }
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = JDBCDynaClass.class$("java.lang.Object")) : class$java$lang$Object;
        if (className != null) {
            clazz = this.loadClass(className);
        }
        return new DynaProperty(name, clazz);
    }

    protected void introspect(ResultSet resultSet) throws SQLException {
        ArrayList<DynaProperty> list2 = new ArrayList<DynaProperty>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int n = metadata.getColumnCount();
        int i = 1;
        while (i <= n) {
            DynaProperty dynaProperty = this.createDynaProperty(metadata, i);
            if (dynaProperty != null) {
                list2.add(dynaProperty);
            }
            ++i;
        }
        this.properties = list2.toArray(new DynaProperty[list2.size()]);
        int i2 = 0;
        while (i2 < this.properties.length) {
            this.propertiesMap.put(this.properties[i2].getName(), this.properties[i2]);
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

