/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$loadLogs$1$;
import kafka.log.LogSegment;
import kafka.server.OffsetCheckpoint;
import kafka.utils.FileLock;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\bY><G)\u001b:t+\u00059\u0002cA\u0005\u00195%\u0011\u0011D\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0018\u0003!awn\u001a#jeN\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0016\u0003\u001d\u0002B\u0001K\u0016.i5\t\u0011F\u0003\u0002+\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051J#aA'baB\u0011a&\r\b\u0003\u0013=J!\u0001\r\u0006\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a)\u0001\"!\u000e\u001c\u000e\u0003\tI!a\u000e\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001bQ|\u0007/[2D_:4\u0017nZ:!\u0011!Y\u0004A!b\u0001\n\u0003a\u0014!\u00043fM\u0006,H\u000e^\"p]\u001aLw-F\u00015\u0011!q\u0004A!A!\u0002\u0013!\u0014A\u00043fM\u0006,H\u000e^\"p]\u001aLw\r\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006i1\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0012A\u0011\t\u0003k\rK!\u0001\u0012\u0002\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0011!1\u0005A!A!\u0002\u0013\u0011\u0015AD2mK\u0006tWM]\"p]\u001aLw\r\t\u0005\t\u0011\u0002\u0011)\u0019!C\u0001\u0013\u0006aa\r\\;tQ\u000eCWmY6NgV\t!\n\u0005\u0002\n\u0017&\u0011AJ\u0003\u0002\u0005\u0019>tw\r\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003K\u000351G.^:i\u0007\",7m['tA!A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011*A\tgYV\u001c\bn\u00115fG.\u0004x.\u001b8u\u001bND\u0001B\u0015\u0001\u0003\u0002\u0003\u0006IAS\u0001\u0013M2,8\u000f[\"iK\u000e\\\u0007o\\5oi6\u001b\b\u0005\u0003\u0005U\u0001\t\u0015\r\u0011\"\u0001J\u0003A\u0011X\r^3oi&|gn\u00115fG.l5\u000f\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003K\u0003E\u0011X\r^3oi&|gn\u00115fG.l5\u000f\t\u0005\t1\u0002\u0011\t\u0011)A\u00053\u0006I1o\u00195fIVdWM\u001d\t\u0003\u001fiK!a\u0017\t\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002C/\u0001\u0005\u000b\u0007I\u0011\u00020\u0002\tQLW.Z\u000b\u0002?B\u0011q\u0002Y\u0005\u0003CB\u0011A\u0001V5nK\"A1\r\u0001B\u0001B\u0003%q,A\u0003uS6,\u0007\u0005C\u0003f\u0001\u0011\u0005a-\u0001\u0004=S:LGO\u0010\u000b\u000bO\"L'n\u001b7n]>\u0004\bCA\u001b\u0001\u0011\u0015)B\r1\u0001\u0018\u0011\u0015)C\r1\u0001(\u0011\u0015YD\r1\u00015\u0011\u0015\u0001E\r1\u0001C\u0011\u0015AE\r1\u0001K\u0011\u0015\u0001F\r1\u0001K\u0011\u0015!F\r1\u0001K\u0011\u0015AF\r1\u0001Z\u0011\u0015iF\r1\u0001`\u0011\u001d\u0011\bA1A\u0005\u0002M\f1DU3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;GS2,W#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]t\u0012\u0001\u00027b]\u001eL!A\r<\t\ri\u0004\u0001\u0015!\u0003u\u0003q\u0011VmY8wKJL\bk\\5oi\u000eCWmY6q_&tGOR5mK\u0002Bq\u0001 \u0001C\u0002\u0013\u00051/\u0001\u0005M_\u000e\\g)\u001b7f\u0011\u0019q\b\u0001)A\u0005i\u0006IAj\\2l\r&dW\r\t\u0005\n\u0003\u0003\u0001!\u0019!C\u0001\u0003\u0007\t!#\u00138ji&\fG\u000eV1tW\u0012+G.Y=NgV\u0011\u0011Q\u0001\t\u0004\u0013\u0005\u001d\u0011bAA\u0005\u0015\t\u0019\u0011J\u001c;\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000b\t1#\u00138ji&\fG\u000eV1tW\u0012+G.Y=Ng\u0002B\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\u000231|wm\u0011:fCRLwN\\(s\t\u0016dW\r^5p]2{7m[\u000b\u0003\u0003+\u00012!^A\f\u0013\r\tIB\u001e\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005u\u0001\u0001)A\u0005\u0003+\t!\u0004\\8h\u0007J,\u0017\r^5p]>\u0013H)\u001a7fi&|g\u000eT8dW\u0002B\u0011\"!\t\u0001\u0005\u0004%I!a\t\u0002\t1|wm]\u000b\u0003\u0003K\u0001raDA\u0014\u0003W\t9$C\u0002\u0002*A\u0011A\u0001U8pYB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022\u0011\taaY8n[>t\u0017\u0002BA\u001b\u0003_\u0011\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\r)\u0014\u0011H\u0005\u0004\u0003w\u0011!a\u0001'pO\"A\u0011q\b\u0001!\u0002\u0013\t)#A\u0003m_\u001e\u001c\b\u0005C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F\u0005AA-\u001b:M_\u000e\\7/\u0006\u0002\u0002HA)\u0001&!\u0013\u0002N%\u0019\u00111J\u0015\u0003\u0007M+\u0017\u000fE\u0002\u0010\u0003\u001fJ1!!\u0015\u0011\u0005!1\u0015\u000e\\3M_\u000e\\\u0007\u0002CA+\u0001\u0001\u0006I!a\u0012\u0002\u0013\u0011L'\u000fT8dWN\u0004\u0003\"CA-\u0001\t\u0007I\u0011BA.\u0003a\u0011XmY8wKJL\bk\\5oi\u000eCWmY6q_&tGo]\u000b\u0003\u0003;\u0002r!a\u0018\u0002fi\t9'\u0004\u0002\u0002b)\u0019\u00111M\u0015\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u0017\u0002bA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n\u0011\taa]3sm\u0016\u0014\u0018\u0002BA9\u0003W\u0012\u0001c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\t\u0011\u0005U\u0004\u0001)A\u0005\u0003;\n\u0011D]3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;tA!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111P\u0001\bG2,\u0017M\\3s+\t\ti\bE\u00026\u0003\u007fJ1!!!\u0003\u0005)aunZ\"mK\u0006tWM\u001d\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002~\u0005A1\r\\3b]\u0016\u0014\b\u0005C\u0004\u0002\n\u0002!I!a#\u00021\r\u0014X-\u0019;f\u0003:$g+\u00197jI\u0006$X\rT8h\t&\u00148\u000f\u0006\u0003\u0002\u000e\u0006M\u0005cA\u0005\u0002\u0010&\u0019\u0011\u0011\u0013\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+\u000b9\t1\u0001\u0002\u0018\u0006!A-\u001b:t!\u0011A\u0013\u0011\n\u000e\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006YAn\\2l\u0019><G)\u001b:t)\u0011\t9%a(\t\u0011\u0005U\u0015\u0011\u0014a\u0001\u0003/Cq!a)\u0001\t\u0013\t)+\u0001\u0005m_\u0006$Gj\\4t)\u0011\ti)a*\t\u0011\u0005U\u0015\u0011\u0015a\u0001\u0003/Cq!a+\u0001\t\u0003\ti+A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u00055\u0005bBAY\u0001\u0011\u0005\u0011QV\u0001\tg\",H\u000fZ8x]\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016A\u0003;sk:\u001c\u0017\r^3U_R!\u0011QRA]\u0011!\tY,a-A\u0002\u0005u\u0016a\u00059beRLG/[8o\u0003:$wJ\u001a4tKR\u001c\b#\u0002\u0015,\u0003WQ\u0005bBAa\u0001\u0011\u0005\u00111Y\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!$\u0002F\u0006%\u0007\u0002CAd\u0003\u007f\u0003\r!a\u000b\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002L\u0006}\u0006\u0019\u0001&\u0002\u00139,wo\u00144gg\u0016$\bbBAh\u0001\u0011\u0005\u0011QV\u0001\u001fG\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010U8j]R|eMZ:fiNDq!a5\u0001\t\u0003\t).\u0001\u0004hKRdun\u001a\u000b\u0005\u0003/\fi\u000eE\u0003\n\u00033\f9$C\u0002\u0002\\*\u0011aa\u00149uS>t\u0007\u0002CAd\u0003#\u0004\r!a\u000b\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\u0006I1M]3bi\u0016dun\u001a\u000b\u0007\u0003o\t)/a:\t\u0011\u0005\u001d\u0017q\u001ca\u0001\u0003WAq!!;\u0002`\u0002\u0007A'\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003[\u0004A\u0011AAx\u0003%!W\r\\3uK2{w\r\u0006\u0003\u0002\u000e\u0006E\b\u0002CAd\u0003W\u0004\r!a\u000b\t\u000f\u0005U\b\u0001\"\u0003\u0002x\u0006Qa.\u001a=u\u0019><G)\u001b:\u0015\u0003iAq!a?\u0001\t\u0013\ti0\u0001\fdY\u0016\fg.\u001e9FqBL'/\u001a3TK\u001elWM\u001c;t)\u0011\t)!a@\t\u000f\r\tI\u00101\u0001\u00028!9!1\u0001\u0001\u0005\n\t\u0015\u0011!H2mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3\u0015\t\u0005\u0015!q\u0001\u0005\b\u0007\t\u0005\u0001\u0019AA\u001c\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003[\u000b1b\u00197fC:,\b\u000fT8hg\"9!q\u0002\u0001\u0005\u0002\tE\u0011aB1mY2{wm\u001d\u000b\u0003\u0005'\u0001R\u0001\u000bB\u000b\u0003oI1Aa\u0006*\u0005!IE/\u001a:bE2,\u0007b\u0002B\u000e\u0001\u0011\u0005!QD\u0001\u0015Y><7OQ=U_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\t}\u0001\u0003CA0\u0003K\nY#a\u000e\t\u000f\t\r\u0002\u0001\"\u0003\u0002.\u0006qa\r\\;tQ\u0012K'\u000f^=M_\u001e\u001c\bf\u0001\u0001\u0003(A\u0019qB!\u000b\n\u0007\t-\u0002C\u0001\u0006uQJ,\u0017\rZ:bM\u0016\u0004")
public class LogManager
implements Logging {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    private final long flushCheckMs;
    private final long flushCheckpointMs;
    private final long retentionCheckMs;
    public final Scheduler kafka$log$LogManager$$scheduler;
    private final Time kafka$log$LogManager$$time;
    private final String RecoveryPointCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints;
    private final LogCleaner kafka$log$LogManager$$cleaner;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogManager logManager = this;
        synchronized (logManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushCheckpointMs() {
        return this.flushCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    public Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints() {
        return this.kafka$log$LogManager$$recoveryPointCheckpoints;
    }

    public LogCleaner kafka$log$LogManager$$cleaner() {
        return this.kafka$log$LogManager$$cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getCanonicalPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        dirs.foreach(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(File dir) {
                block5: {
                    block4: {
                        if (dir.exists()) break block4;
                        this.$outer.info((Function0<String>)((Object)new scala.Serializable(this, dir){
                            public static final long serialVersionUID = 0L;
                            private final File dir$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Log directory '").append((Object)this.dir$1.getAbsolutePath()).append((Object)"' not found, creating it.").toString();
                            }
                            {
                                this.dir$1 = dir$1;
                            }
                        }));
                        boolean created = dir.mkdirs();
                        if (!created) break block5;
                    }
                    if (dir.isDirectory() && dir.canRead()) {
                        return;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)dir.getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to create data directory ").append((Object)dir.getAbsolutePath()).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return dirs.map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            /*
             * WARNING - void declaration
             */
            public final FileLock apply(File dir) {
                void var2_2;
                FileLock lock2 = new FileLock(new File(dir, this.$outer.LockFile()));
                if (lock2.tryLock()) {
                    return var2_2;
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to acquire lock on file .lock in ").append((Object)var2_2.file().getParentFile().getAbsolutePath()).append((Object)". A Kafka instance in another process or thread is using this directory.").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs(Seq<File> dirs) {
        dirs.foreach(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final Object apply(File dir) {
                Serializable serializable2;
                Map<TopicAndPartition, Object> recoveryPoints = ((OffsetCheckpoint)this.$outer.kafka$log$LogManager$$recoveryPointCheckpoints().apply(dir)).read();
                File[] subDirs = dir.listFiles();
                if (subDirs != null) {
                    File cleanShutDownFile = new File(dir, Log$.MODULE$.CleanShutdownFile());
                    if (cleanShutDownFile.exists()) {
                        this.$outer.info((Function0<String>)((Object)new scala.Serializable(this, dir){
                            public static final long serialVersionUID = 0L;
                            private final File dir$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Found clean shutdown file. Skipping recovery for all logs in data directory '%s'")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.dir$2.getAbsolutePath()}));
                            }
                            {
                                this.dir$2 = dir$2;
                            }
                        }));
                    }
                    Predef$.MODULE$.refArrayOps((Object[])subDirs).foreach(new scala.Serializable(this, recoveryPoints){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$loadLogs$1 $outer;
                        private final Map recoveryPoints$1;

                        public final void apply(File dir) {
                            if (dir.isDirectory()) {
                                this.$outer.kafka$log$LogManager$$anonfun$$$outer().info((Function0<String>)((Object)new scala.Serializable(this, dir){
                                    public static final long serialVersionUID = 0L;
                                    private final File dir$3;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Loading log '").append((Object)this.dir$3.getName()).append((Object)"'").toString();
                                    }
                                    {
                                        this.dir$3 = dir$3;
                                    }
                                }));
                                TopicAndPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(dir.getName());
                                LogConfig config = this.$outer.kafka$log$LogManager$$anonfun$$$outer().topicConfigs().getOrElse(topicPartition.topic(), new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$loadLogs$1$$anonfun$apply$4 $outer;

                                    public final LogConfig apply() {
                                        return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().defaultConfig();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                Log log2 = new Log(dir, config, BoxesRunTime.unboxToLong(this.recoveryPoints$1.getOrElse(topicPartition, new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return 0L;
                                    }
                                })), this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$scheduler, this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$time());
                                Log previous = this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logs().put(topicPartition, log2);
                                if (previous != null) {
                                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!")).format(Predef$.MODULE$.genericWrapArray(new Object[]{log2.dir().getAbsolutePath(), previous.dir().getAbsolutePath()})));
                                }
                            }
                        }

                        public /* synthetic */ $anonfun$loadLogs$1 kafka$log$LogManager$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.recoveryPoints$1 = recoveryPoints$1;
                        }
                    });
                    serializable2 = BoxesRunTime.boxToBoolean(cleanShutDownFile.delete());
                } else {
                    serializable2 = BoxedUnit.UNIT;
                }
                return serializable2;
            }

            public /* synthetic */ LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void startup() {
        if (this.kafka$log$LogManager$$scheduler != null) {
            this.info((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Starting log cleanup with a period of %d ms.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.retentionCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-retention", (Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleanupLogs();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
            this.info((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Starting log flusher with a default period of %d ms.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.flushCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-flusher", (Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$flushDirtyLogs();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
            this.kafka$log$LogManager$$scheduler.schedule("kafka-recovery-point-checkpoint", (Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointRecoveryPointOffsets();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), this.flushCheckpointMs(), TimeUnit.MILLISECONDS);
        }
        if (this.cleanerConfig().enableCleaner()) {
            this.kafka$log$LogManager$$cleaner().startup();
        }
    }

    public void shutdown() {
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down.";
            }
        }));
        try {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogManager $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$log$LogManager$$cleaner().shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            this.allLogs().foreach(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Log x$2) {
                    x$2.flush();
                }
            });
            this.allLogs().foreach(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Log x$3) {
                    x$3.close();
                }
            });
            this.checkpointRecoveryPointOffsets();
            Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(File dir) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new scala.Serializable(this, dir){
                        public static final long serialVersionUID = 0L;
                        private final File dir$4;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            new File(this.dir$4, Log$.MODULE$.CleanShutdownFile()).createNewFile();
                        }
                        {
                            this.dir$4 = dir$4;
                        }
                    }));
                }
            });
        }
        catch (Throwable throwable) {
            this.dirLocks().foreach(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FileLock x$4) {
                    x$4.destroy();
                }
            });
            throw throwable;
        }
        this.dirLocks().foreach(new /* invalid duplicate definition of identical inner class */);
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown complete.";
            }
        }));
    }

    public void truncateTo(Map<TopicAndPartition, Object> partitionAndOffsets) {
        partitionAndOffsets.withFilter((Function1<TopicAndPartition, Object>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Object> check$ifrefutable$1) {
                Tuple2<TopicAndPartition, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(Tuple2<TopicAndPartition, Object> x$5) {
                Tuple2<TopicAndPartition, Object> tuple2 = x$5;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicAndPartition topicAndPartition = tuple2._1();
                    long truncateOffset = tuple2._2$mcJ$sp();
                    Log log2 = this.$outer.kafka$log$LogManager$$logs().get(topicAndPartition);
                    if (log2 == null) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean needToStopCleaner;
                        boolean bl = needToStopCleaner = truncateOffset < log2.activeSegment().baseOffset();
                        if (needToStopCleaner && this.$outer.kafka$log$LogManager$$cleaner() != null) {
                            this.$outer.kafka$log$LogManager$$cleaner().abortAndPauseCleaning(topicAndPartition);
                        }
                        log2.truncateTo(truncateOffset);
                        if (needToStopCleaner && this.$outer.kafka$log$LogManager$$cleaner() != null) {
                            this.$outer.kafka$log$LogManager$$cleaner().resumeCleaning(topicAndPartition);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicAndPartition topicAndPartition, long newOffset) {
        Log log2 = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        if (log2 != null) {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().abortAndPauseCleaning(topicAndPartition);
            }
            log2.truncateFullyAndStartAt(newOffset);
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().resumeCleaning(topicAndPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        scala.collection.immutable.Map recoveryPointsByDir = this.logsByTopicPartition().groupBy(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Log> x$6) {
                return x$6._2().dir().getParent().toString();
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new scala.Serializable(this, recoveryPointsByDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final scala.collection.immutable.Map recoveryPointsByDir$1;

            public final void apply(File dir) {
                Option<B> recoveryPoints = this.recoveryPointsByDir$1.get(dir.toString());
                if (recoveryPoints.isDefined()) {
                    ((OffsetCheckpoint)this.$outer.kafka$log$LogManager$$recoveryPointCheckpoints().apply(dir)).write(((MapLike)recoveryPoints.get()).mapValues(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Log x$7) {
                            return x$7.recoveryPoint();
                        }
                    }));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.recoveryPointsByDir$1 = recoveryPointsByDir$1;
            }
        });
    }

    public Option<Log> getLog(TopicAndPartition topicAndPartition) {
        Log log2 = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        return log2 == null ? None$.MODULE$ : new Some<Log>(log2);
    }

    /*
     * WARNING - void declaration
     */
    public Log createLog(TopicAndPartition topicAndPartition, LogConfig config) {
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            void var5_4;
            block4: {
                Log log2 = this.kafka$log$LogManager$$logs().get(topicAndPartition);
                if (log2 != null) break block4;
                File dataDir = this.nextLogDir();
                File dir = new File(dataDir, new StringBuilder().append((Object)topicAndPartition.topic()).append((Object)"-").append(BoxesRunTime.boxToInteger(topicAndPartition.partition())).toString());
                dir.mkdirs();
                log2 = new Log(dir, config, 0L, this.kafka$log$LogManager$$scheduler, this.kafka$log$LogManager$$time());
                this.kafka$log$LogManager$$logs().put(topicAndPartition, log2);
                this.info((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition, config, dataDir){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$1;
                    private final LogConfig config$1;
                    private final File dataDir$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s with properties {%s}.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1.topic(), BoxesRunTime.boxToInteger(this.topicAndPartition$1.partition()), this.dataDir$1.getAbsolutePath(), JavaConversions$.MODULE$.propertiesAsScalaMap(this.config$1.toProps()).mkString(", ")}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.config$1 = config$1;
                        this.dataDir$1 = dataDir$1;
                    }
                }));
                Log log3 = log2;
                return log3;
            }
            return var5_4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteLog(TopicAndPartition topicAndPartition) {
        ObjectRef<Object> removedLog = new ObjectRef<Object>(null);
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            removedLog.elem = this.kafka$log$LogManager$$logs().remove(topicAndPartition);
        }
        if ((Log)removedLog.elem != null) {
            if (this.kafka$log$LogManager$$cleaner() != null) {
                this.kafka$log$LogManager$$cleaner().abortCleaning(topicAndPartition);
            }
            ((Log)removedLog.elem).delete();
            this.info((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition, removedLog){
                public static final long serialVersionUID = 0L;
                private final TopicAndPartition topicAndPartition$2;
                private final ObjectRef removedLog$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deleted log for partition [%s,%d] in %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$2.topic(), BoxesRunTime.boxToInteger(this.topicAndPartition$2.partition()), ((Log)this.removedLog$1.elem).dir().getAbsolutePath()}));
                }
                {
                    this.topicAndPartition$2 = topicAndPartition$2;
                    this.removedLog$1 = removedLog$1;
                }
            }));
        }
    }

    private File nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Log x$8) {
                    return x$8.dir().getParent();
                }
            }).mapValues(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Iterable<Log> x$9) {
                    return x$9.size();
                }
            });
            scala.collection.immutable.Map zeros = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(File dir) {
                    return new Tuple2<String, Object>(dir.getPath(), BoxesRunTime.boxToInteger(0));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
            Buffer<Object> dirCounts = zeros.$plus$plus(logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, Object> x$10) {
                    return x$10._2$mcI$sp();
                }
            }, Ordering$Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public int kafka$log$LogManager$$cleanupExpiredSegments(Log log2) {
        long startMs = this.kafka$log$LogManager$$time().milliseconds();
        return log2.deleteOldSegments((Function1<LogSegment, Object>)((Object)new scala.Serializable(this, log2, startMs){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long startMs$1;

            public final boolean apply(LogSegment x$11) {
                return this.startMs$1 - x$11.lastModified() > this.log$2.config().retentionMs();
            }
            {
                this.log$2 = log$2;
                this.startMs$1 = startMs$1;
            }
        }));
    }

    public int kafka$log$LogManager$$cleanupSegmentsToMaintainSize(Log log2) {
        if (log2.config().retentionSize() < 0L || log2.size() < log2.config().retentionSize()) {
            return 0;
        }
        LongRef diff2 = new LongRef(log2.size() - log2.config().retentionSize());
        return log2.deleteOldSegments((Function1<LogSegment, Object>)((Object)new scala.Serializable(this, diff2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final LongRef diff$1;

            public final boolean apply(LogSegment segment) {
                return this.$outer.kafka$log$LogManager$$shouldDelete$1(segment, this.diff$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.diff$1 = diff$1;
            }
        }));
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Beginning log cleanup...";
            }
        }));
        IntRef total = new IntRef(0);
        long startMs = this.kafka$log$LogManager$$time().milliseconds();
        this.allLogs().withFilter((Function1<Log, Object>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Log log2) {
                return !log2.config().compact();
            }
        })).foreach(new scala.Serializable(this, total){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final IntRef total$1;

            public final void apply(Log log2) {
                this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$3;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$3.name()).append((Object)"'").toString();
                    }
                    {
                        this.log$3 = log$3;
                    }
                }));
                this.total$1.elem += this.$outer.kafka$log$LogManager$$cleanupExpiredSegments(log2) + this.$outer.kafka$log$LogManager$$cleanupSegmentsToMaintainSize(log2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$1 = total$1;
            }
        });
        this.debug((Function0<String>)((Object)new scala.Serializable(this, total, startMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final IntRef total$1;
            private final long startMs$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append(BoxesRunTime.boxToInteger(this.total$1.elem)).append((Object)" files deleted in ").append(BoxesRunTime.boxToLong((this.$outer.kafka$log$LogManager$$time().milliseconds() - this.startMs$2) / 1000L)).append((Object)" seconds").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$1 = total$1;
                this.startMs$2 = startMs$2;
            }
        }));
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public scala.collection.immutable.Map<TopicAndPartition, Log> logsByTopicPartition() {
        return this.kafka$log$LogManager$$logs().toMap(Predef$.MODULE$.conforms());
    }

    public void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Checking for dirty logs to flush...";
            }
        }));
        this.kafka$log$LogManager$$logs().withFilter(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Log> check$ifrefutable$2) {
                Tuple2<TopicAndPartition, Log> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<TopicAndPartition, Log> x$12) {
                BoxedUnit boxedUnit;
                Tuple2<TopicAndPartition, Log> tuple2 = x$12;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicAndPartition topicAndPartition = tuple2._1();
                Log log2 = tuple2._2();
                try {
                    long timeSinceLastFlush = this.$outer.kafka$log$LogManager$$time().milliseconds() - log2.lastFlushTime();
                    this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition, log2, timeSinceLastFlush){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition topicAndPartition$3;
                        private final Log log$1;
                        private final long timeSinceLastFlush$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Checking if flush is needed on ").append((Object)this.topicAndPartition$3.topic()).append((Object)" flush interval  ").append(BoxesRunTime.boxToLong(this.log$1.config().flushMs())).append((Object)" last flushed ").append(BoxesRunTime.boxToLong(this.log$1.lastFlushTime())).append((Object)" time since last flush: ").append(BoxesRunTime.boxToLong(this.timeSinceLastFlush$1)).toString();
                        }
                        {
                            this.topicAndPartition$3 = topicAndPartition$3;
                            this.log$1 = log$1;
                            this.timeSinceLastFlush$1 = timeSinceLastFlush$1;
                        }
                    }));
                    if (timeSinceLastFlush >= log2.config().flushMs()) {
                        log2.flush();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)((Object)new scala.Serializable(this, topicAndPartition){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition topicAndPartition$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.topicAndPartition$3.topic()).toString();
                        }
                        {
                            this.topicAndPartition$3 = topicAndPartition$3;
                        }
                    }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    }));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final boolean kafka$log$LogManager$$shouldDelete$1(LogSegment segment, LongRef diff$1) {
        boolean bl;
        if (diff$1.elem - segment.size() >= 0L) {
            diff$1.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, long flushCheckMs, long flushCheckpointMs, long retentionCheckMs, Scheduler scheduler, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.flushCheckMs = flushCheckMs;
        this.flushCheckpointMs = flushCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.kafka$log$LogManager$$scheduler = scheduler;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.createAndValidateLogDirs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$recoveryPointCheckpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map(new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        this.loadLogs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.kafka$log$LogManager$$logs(), time) : null;
    }
}

