/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.OffsetRequest$;
import kafka.common.Config;
import kafka.common.Config$class;
import kafka.common.InvalidConfigException;
import kafka.consumer.ConsumerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerConfig$
implements Config {
    public static final ConsumerConfig$ MODULE$;
    private final int RefreshMetadataBackoffMs;
    private final int SocketTimeout;
    private final int SocketBufferSize;
    private final int FetchSize;
    private final int MaxFetchSize;
    private final int NumConsumerFetchers;
    private final int DefaultFetcherBackoffMs;
    private final boolean AutoCommit;
    private final int AutoCommitInterval;
    private final int MaxQueuedChunks;
    private final int MaxRebalanceRetries;
    private final String AutoOffsetReset;
    private final int ConsumerTimeoutMs;
    private final int MinFetchBytes;
    private final int MaxFetchWaitMs;
    private final String MirrorTopicsWhitelist;
    private final String MirrorTopicsBlacklist;
    private final int MirrorConsumerNumThreads;
    private final String MirrorTopicsWhitelistProp;
    private final String MirrorTopicsBlacklistProp;
    private final String MirrorConsumerNumThreadsProp;
    private final String DefaultClientId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsumerConfig$();
    }

    @Override
    public void validateChars(String prop, String value2) {
        Config$class.validateChars(this, prop, value2);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerConfig$ consumerConfig$ = this;
        synchronized (consumerConfig$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int RefreshMetadataBackoffMs() {
        return this.RefreshMetadataBackoffMs;
    }

    public int SocketTimeout() {
        return this.SocketTimeout;
    }

    public int SocketBufferSize() {
        return this.SocketBufferSize;
    }

    public int FetchSize() {
        return this.FetchSize;
    }

    public int MaxFetchSize() {
        return this.MaxFetchSize;
    }

    public int NumConsumerFetchers() {
        return this.NumConsumerFetchers;
    }

    public int DefaultFetcherBackoffMs() {
        return this.DefaultFetcherBackoffMs;
    }

    public boolean AutoCommit() {
        return this.AutoCommit;
    }

    public int AutoCommitInterval() {
        return this.AutoCommitInterval;
    }

    public int MaxQueuedChunks() {
        return this.MaxQueuedChunks;
    }

    public int MaxRebalanceRetries() {
        return this.MaxRebalanceRetries;
    }

    public String AutoOffsetReset() {
        return this.AutoOffsetReset;
    }

    public int ConsumerTimeoutMs() {
        return this.ConsumerTimeoutMs;
    }

    public int MinFetchBytes() {
        return this.MinFetchBytes;
    }

    public int MaxFetchWaitMs() {
        return this.MaxFetchWaitMs;
    }

    public String MirrorTopicsWhitelist() {
        return this.MirrorTopicsWhitelist;
    }

    public String MirrorTopicsBlacklist() {
        return this.MirrorTopicsBlacklist;
    }

    public int MirrorConsumerNumThreads() {
        return this.MirrorConsumerNumThreads;
    }

    public String MirrorTopicsWhitelistProp() {
        return this.MirrorTopicsWhitelistProp;
    }

    public String MirrorTopicsBlacklistProp() {
        return this.MirrorTopicsBlacklistProp;
    }

    public String MirrorConsumerNumThreadsProp() {
        return this.MirrorConsumerNumThreadsProp;
    }

    public String DefaultClientId() {
        return this.DefaultClientId;
    }

    public void validate(ConsumerConfig config) {
        this.validateClientId(config.clientId());
        this.validateGroupId(config.groupId());
        this.validateAutoOffsetReset(config.autoOffsetReset());
    }

    public void validateClientId(String clientId) {
        this.validateChars("client.id", clientId);
    }

    public void validateGroupId(String groupId) {
        this.validateChars("group.id", groupId);
    }

    public void validateAutoOffsetReset(String autoOffsetReset) {
        block4: {
            block3: {
                String string2;
                block2: {
                    string2 = autoOffsetReset;
                    String string3 = OffsetRequest$.MODULE$.SmallestTimeString();
                    String string4 = string2;
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string5 = OffsetRequest$.MODULE$.LargestTimeString();
                String string6 = string2;
                if (string5 != null ? !string5.equals(string6) : string6 != null) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new InvalidConfigException(new StringBuilder().append((Object)"Wrong value ").append((Object)autoOffsetReset).append((Object)" of auto.offset.reset in ConsumerConfig; ").append((Object)"Valid values are ").append((Object)OffsetRequest$.MODULE$.SmallestTimeString()).append((Object)" and ").append((Object)OffsetRequest$.MODULE$.LargestTimeString()).toString());
    }

    private ConsumerConfig$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
        this.RefreshMetadataBackoffMs = 200;
        this.SocketTimeout = 30000;
        this.SocketBufferSize = 65536;
        this.FetchSize = 0x100000;
        this.MaxFetchSize = 10 * this.FetchSize();
        this.NumConsumerFetchers = 1;
        this.DefaultFetcherBackoffMs = 1000;
        this.AutoCommit = true;
        this.AutoCommitInterval = 60000;
        this.MaxQueuedChunks = 2;
        this.MaxRebalanceRetries = 4;
        this.AutoOffsetReset = OffsetRequest$.MODULE$.LargestTimeString();
        this.ConsumerTimeoutMs = -1;
        this.MinFetchBytes = 1;
        this.MaxFetchWaitMs = 100;
        this.MirrorTopicsWhitelist = "";
        this.MirrorTopicsBlacklist = "";
        this.MirrorConsumerNumThreads = 1;
        this.MirrorTopicsWhitelistProp = "mirror.topics.whitelist";
        this.MirrorTopicsBlacklistProp = "mirror.topics.blacklist";
        this.MirrorConsumerNumThreadsProp = "mirror.consumer.numthreads";
        this.DefaultClientId = "";
    }
}

