/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.Broker;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %s does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object m = some.x();
                Map brokerInfo = (Map)m;
                String host = (String)brokerInfo.get("host").get();
                int port = BoxesRunTime.unboxToInt(brokerInfo.get("port").get());
                Broker broker = new Broker(id, host, port);
                return broker;
            }
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringBuilder().append((Object)"Failed to parse the broker info from zookeeper: ").append((Object)brokerInfoString).toString(), throwable);
        }
    }

    public Broker readFrom(ByteBuffer buffer) {
        int id = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new Broker(id, host, port);
    }

    public Broker apply(int id, String host, int port) {
        return new Broker(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, String, Integer>>(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(x$0.id()), x$0.host(), BoxesRunTime.boxToInteger(x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

