/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.common.ErrorMapping$;
import kafka.network.BoundedByteBufferSend;
import kafka.network.RequestChannel;
import scala.Product;
import scala.Product$class;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005}x!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006+pa&\u001cW*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bU_BL7-T3uC\u0012\fG/\u0019*fcV,7\u000f^\n\u0005\u00131\u0011\u0002\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!\u001e;jYNL!a\u0006\u000b\u0003\u000f1{wmZ5oOB\u0011Q\"G\u0005\u000359\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\u0005\u0005\u0002u\ta\u0001P5oSRtD#A\u0004\t\u000f}I!\u0019!C\u0001A\u0005q1)\u001e:sK:$h+\u001a:tS>tW#A\u0011\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019)\u0013\u0002)A\u0005C\u0005y1)\u001e:sK:$h+\u001a:tS>t\u0007\u0005C\u0004(\u0013\t\u0007I\u0011\u0001\u0015\u0002\u001f\u0011+g-Y;mi\u000ec\u0017.\u001a8u\u0013\u0012,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!'\u0003Q\u0001\n%\n\u0001\u0003R3gCVdGo\u00117jK:$\u0018\n\u001a\u0011\t\u000bQJA\u0011A\u001b\u0002\u0011I,\u0017\r\u001a$s_6$2ANAg!\tAqG\u0002\u0003\u000b\u0005\u0001C4\u0003B\u001c:ya\u0001\"\u0001\u0003\u001e\n\u0005m\u0012!!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tKB\u0011Q\"P\u0005\u0003}9\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u0005Ao\tU\r\u0011\"\u0001!\u0003%1XM]:j_:LE\r\u0003\u0005Co\tE\t\u0015!\u0003\"\u0003)1XM]:j_:LE\r\t\u0005\t\t^\u0012)\u001a!C!\u000b\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012,\u0012A\u0012\t\u0003\u001b\u001dK!\u0001\u0013\b\u0003\u0007%sG\u000fC\u0005Ko\tE\t\u0015!\u0003G\u0017\u0006q1m\u001c:sK2\fG/[8o\u0013\u0012\u0004\u0013B\u0001#;\u0011!iuG!f\u0001\n\u0003q\u0015\u0001C2mS\u0016tG/\u00133\u0016\u0003=\u0003\"\u0001U*\u000f\u00055\t\u0016B\u0001*\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001\u0007\u0016\u0006\u0003%:A\u0001BV\u001c\u0003\u0012\u0003\u0006IaT\u0001\nG2LWM\u001c;JI\u0002B\u0001\u0002W\u001c\u0003\u0016\u0004%\t!W\u0001\u0007i>\u0004\u0018nY:\u0016\u0003i\u00032aW2P\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`\r\u00051AH]8pizJ\u0011aD\u0005\u0003E:\tq\u0001]1dW\u0006<W-\u0003\u0002eK\n\u00191+Z9\u000b\u0005\tt\u0001\u0002C48\u0005#\u0005\u000b\u0011\u0002.\u0002\u000fQ|\u0007/[2tA!)Ad\u000eC\u0001SR)aG[6m[\")\u0001\t\u001ba\u0001C!)A\t\u001ba\u0001\r\")Q\n\u001ba\u0001\u001f\")\u0001\f\u001ba\u00015\")Ad\u000eC\u0001_R\u0019a\u0007]9\t\u000bas\u0007\u0019\u0001.\t\u000b\u0011s\u0007\u0019\u0001$\t\u000bM<D\u0011\u0001;\u0002\u000f]\u0014\u0018\u000e^3U_R\u0011Q\u000f\u001f\t\u0003\u001bYL!a\u001e\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006sJ\u0004\rA_\u0001\u0007EV4g-\u001a:\u0011\u0005mtX\"\u0001?\u000b\u0005ul\u0013a\u00018j_&\u0011q\u0010 \u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA\u0002o\u0011\u0005\u0011QA\u0001\fg&TX-\u00138CsR,7\u000fF\u0001G\u0011\u001d\tIa\u000eC!\u0003\u0017\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u001f\"9\u0011qB\u001c\u0005B\u0005E\u0011a\u00035b]\u0012dW-\u0012:s_J$r!^A\n\u0003;\ti\u0003\u0003\u0005\u0002\u0016\u00055\u0001\u0019AA\f\u0003\u0005)\u0007cA.\u0002\u001a%\u0019\u00111D3\u0003\u0013QC'o\\<bE2,\u0007\u0002CA\u0010\u0003\u001b\u0001\r!!\t\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(\u0011\tqA\\3uo>\u00148.\u0003\u0003\u0002,\u0005\u0015\"A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\t\u0003_\ti\u00011\u0001\u00022\u00059!/Z9vKN$\b\u0003BA\u001a\u0003sqA!a\t\u00026%!\u0011qGA\u0013\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!a\u000f\u0002>\t9!+Z9vKN$(\u0002BA\u001c\u0003KAq!!\u00118\t\u0003\n\u0019%\u0001\u0005eKN\u001c'/\u001b2f)\ry\u0015Q\t\u0005\t\u0003\u000f\ny\u00041\u0001\u0002J\u00059A-\u001a;bS2\u001c\bcA\u0007\u0002L%\u0019\u0011Q\n\b\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011K\u001c\u0002\u0002\u0013\u0005\u00111K\u0001\u0005G>\u0004\u0018\u0010F\u00057\u0003+\n9&!\u0017\u0002\\!A\u0001)a\u0014\u0011\u0002\u0003\u0007\u0011\u0005\u0003\u0005E\u0003\u001f\u0002\n\u00111\u0001G\u0011!i\u0015q\nI\u0001\u0002\u0004y\u0005\u0002\u0003-\u0002PA\u0005\t\u0019\u0001.\t\u0013\u0005}s'%A\u0005\u0002\u0005\u0005\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GR3!IA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA=oE\u0005I\u0011AA>\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!! +\u0007\u0019\u000b)\u0007C\u0005\u0002\u0002^\n\n\u0011\"\u0001\u0002\u0004\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAACU\ry\u0015Q\r\u0005\n\u0003\u0013;\u0014\u0013!C\u0001\u0003\u0017\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u000e*\u001a!,!\u001a\t\u0011\u0005Eu'!A\u0005B!\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\u0002CAKo\u0005\u0005I\u0011A#\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005eu'!A\u0005\u0002\u0005m\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002\u000e\u0003?K1!!)\u000f\u0005\r\te.\u001f\u0005\n\u0003K\u000b9*!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0011%\tIkNA\u0001\n\u0003\nY+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u000b\u0005\u0004\u00020\u0006U\u0016QT\u0007\u0003\u0003cS1!a-\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\u000b\tL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tYlNA\u0001\n\u0003\ti,\u0001\u0005dC:,\u0015/^1m)\u0011\tI%a0\t\u0015\u0005\u0015\u0016\u0011XA\u0001\u0002\u0004\ti\nC\u0005\u0002D^\n\t\u0011\"\u0011\u0002\u0006\u0005A\u0001.Y:i\u0007>$W\rC\u0005\u0002H^\n\t\u0011\"\u0011\u0002J\u00061Q-];bYN$B!!\u0013\u0002L\"Q\u0011QUAc\u0003\u0003\u0005\r!!(\t\u000be\u001c\u0004\u0019\u0001>\t\u0013\u0005E\u0017\"!A\u0005\u0002\u0006M\u0017!B1qa2LH#\u0003\u001c\u0002V\u0006]\u0017\u0011\\An\u0011\u0019\u0001\u0015q\u001aa\u0001C!1A)a4A\u0002\u0019Ca!TAh\u0001\u0004y\u0005B\u0002-\u0002P\u0002\u0007!\fC\u0005\u0002`&\t\t\u0011\"!\u0002b\u00069QO\\1qa2LH\u0003BAr\u0003_\u0004R!DAs\u0003SL1!a:\u000f\u0005\u0019y\u0005\u000f^5p]B9Q\"a;\"\r>S\u0016bAAw\u001d\t1A+\u001e9mKRBq!!=\u0002^\u0002\u0007a'A\u0002yIAB\u0011\"!>\n\u0003\u0003%I!a>\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u00042AKA~\u0013\r\tip\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class TopicMetadataRequest
extends RequestOrResponse
implements Product,
scala.Serializable {
    private final short versionId;
    private final String clientId;
    private final Seq<String> topics;

    public static TopicMetadataRequest readFrom(ByteBuffer byteBuffer) {
        return TopicMetadataRequest$.MODULE$.readFrom(byteBuffer);
    }

    public static String DefaultClientId() {
        return TopicMetadataRequest$.MODULE$.DefaultClientId();
    }

    public static short CurrentVersion() {
        return TopicMetadataRequest$.MODULE$.CurrentVersion();
    }

    public short versionId() {
        return this.versionId;
    }

    @Override
    public int correlationId() {
        return super.correlationId();
    }

    public String clientId() {
        return this.clientId;
    }

    public Seq<String> topics() {
        return this.topics;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.putShort(this.versionId());
        buffer.putInt(this.correlationId());
        ApiUtils$.MODULE$.writeShortString(buffer, this.clientId());
        buffer.putInt(this.topics().size());
        this.topics().foreach(new scala.Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$2;

            public final void apply(String topic) {
                ApiUtils$.MODULE$.writeShortString(this.buffer$2, topic);
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
    }

    @Override
    public int sizeInBytes() {
        return 6 + ApiUtils$.MODULE$.shortStringLength(this.clientId()) + 4 + BoxesRunTime.unboxToInt(this.topics().foldLeft(BoxesRunTime.boxToInteger(0), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, String x$2) {
                return x$1 + ApiUtils$.MODULE$.shortStringLength(x$2);
            }
        }));
    }

    public String toString() {
        return this.describe(true);
    }

    @Override
    public void handleError(Throwable e, RequestChannel requestChannel, RequestChannel.Request request) {
        Seq<TopicMetadata> topicMetadata = this.topics().map(new scala.Serializable(this, e){
            public static final long serialVersionUID = 0L;
            private final Throwable e$1;

            public final TopicMetadata apply(String topic) {
                return new TopicMetadata(topic, Nil$.MODULE$, ErrorMapping$.MODULE$.codeFor(this.e$1.getClass()));
            }
            {
                this.e$1 = e$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TopicMetadataResponse errorResponse = new TopicMetadataResponse(topicMetadata, this.correlationId());
        requestChannel.sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(errorResponse)));
    }

    @Override
    public String describe(boolean details) {
        StringBuilder topicMetadataRequest = new StringBuilder();
        topicMetadataRequest.append(new StringBuilder().append((Object)"Name: ").append((Object)this.getClass().getSimpleName()).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; Version: ").append(BoxesRunTime.boxToShort(this.versionId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; CorrelationId: ").append(BoxesRunTime.boxToInteger(this.correlationId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; ClientId: ").append((Object)this.clientId()).toString());
        Serializable serializable2 = details ? topicMetadataRequest.append(new StringBuilder().append((Object)"; Topics: ").append((Object)this.topics().mkString(",")).toString()) : BoxedUnit.UNIT;
        return topicMetadataRequest.toString();
    }

    public TopicMetadataRequest copy(short versionId, int correlationId, String clientId, Seq<String> topics) {
        return new TopicMetadataRequest(versionId, correlationId, clientId, topics);
    }

    public short copy$default$1() {
        return this.versionId();
    }

    public int copy$default$2() {
        return this.correlationId();
    }

    public String copy$default$3() {
        return this.clientId();
    }

    public Seq<String> copy$default$4() {
        return this.topics();
    }

    @Override
    public String productPrefix() {
        return "TopicMetadataRequest";
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
            case 3: {
                object = this.topics();
                break;
            }
            case 2: {
                object = this.clientId();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger(this.correlationId());
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToShort(this.versionId());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopicMetadataRequest;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.versionId());
        n = Statics.mix(n, this.correlationId());
        n = Statics.mix(n, Statics.anyHash(this.clientId()));
        n = Statics.mix(n, Statics.anyHash(this.topics()));
        return Statics.finalizeHash(n, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopicMetadataRequest)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopicMetadataRequest topicMetadataRequest = (TopicMetadataRequest)x$1;
        if (this.versionId() != topicMetadataRequest.versionId()) return false;
        if (this.correlationId() != topicMetadataRequest.correlationId()) return false;
        String string2 = this.clientId();
        String string3 = topicMetadataRequest.clientId();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Seq<String> seq = this.topics();
        Seq<String> seq2 = topicMetadataRequest.topics();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!topicMetadataRequest.canEqual(this)) return false;
        return true;
    }

    public TopicMetadataRequest(short versionId, int correlationId, String clientId, Seq<String> topics) {
        this.versionId = versionId;
        this.clientId = clientId;
        this.topics = topics;
        super(new Some<Object>(BoxesRunTime.boxToShort(RequestKeys$.MODULE$.MetadataKey())), correlationId);
        Product$class.$init$(this);
    }

    public TopicMetadataRequest(Seq<String> topics, int correlationId) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }
}

