/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ShutdownBroker;
import kafka.common.BrokerNotAvailableException;
import kafka.controller.KafkaController$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ShutdownBroker$
implements Logging {
    public static final ShutdownBroker$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ShutdownBroker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ShutdownBroker$ shutdownBroker$ = this;
        synchronized (shutdownBroker$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Unable to fully structure code
     */
    public boolean kafka$admin$ShutdownBroker$$invokeShutdown(ShutdownBroker.ShutdownParams params) {
        block10: {
            block9: {
                zkClient = null;
                zkClient = new ZkClient(params.zkConnect(), 30000, 30000, ZKStringSerializer$.MODULE$);
                controllerBrokerId = ZkUtils$.MODULE$.getController(zkClient);
                var6_4 = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(controllerBrokerId)).toString())._1();
                if (!(var6_4 instanceof Some)) ** GOTO lbl45
                var7_5 = (Some)var6_4;
                controllerInfo = (String)var7_5.x();
                controllerHost = null;
                controllerJmxPort = -1;
                var12_9 = Json$.MODULE$.parseFull(controllerInfo);
                if (!(var12_9 instanceof Some)) break block9;
                var13_10 = (Some)var12_9;
                m = var13_10.x();
                brokerInfo = (Map)m;
                controllerHost = brokerInfo.get("host").get().toString();
                controllerJmxPort = BoxesRunTime.unboxToInt(brokerInfo.get("jmx_port").get());
                var15_13 = BoxedUnit.UNIT;
                jmxUrl = new JMXServiceURL(new StringOps(Predef$.MODULE$.augmentString("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi")).format(Predef$.MODULE$.genericWrapArray(new Object[]{controllerHost, BoxesRunTime.boxToInteger(controllerJmxPort)})));
                this.info((Function0<String>)new Serializable(jmxUrl){
                    public static final long serialVersionUID = 0L;
                    private final JMXServiceURL jmxUrl$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Connecting to jmx url ").append(this.jmxUrl$1).toString();
                    }
                    {
                        this.jmxUrl$1 = jmxUrl$1;
                    }
                });
                jmxc = JMXConnectorFactory.connect(jmxUrl, null);
                mbsc = jmxc.getMBeanServerConnection();
                leaderPartitionsRemaining = (Set)mbsc.invoke(new ObjectName(KafkaController$.MODULE$.MBeanName()), "shutdownBroker", new Object[]{params.brokerId()}, (String[])((Object[])new String[]{Integer.TYPE.getName()}));
                shutdownComplete = leaderPartitionsRemaining.size() == 0;
                this.info((Function0<String>)new Serializable(leaderPartitionsRemaining, shutdownComplete){
                    public static final long serialVersionUID = 0L;
                    private final Set leaderPartitionsRemaining$1;
                    private final boolean shutdownComplete$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Shutdown status: ").append((Object)(this.shutdownComplete$1 ? "complete" : new StringOps(Predef$.MODULE$.augmentString("incomplete (broker still leads %d partitions)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.leaderPartitionsRemaining$1})))).toString();
                    }
                    {
                        this.leaderPartitionsRemaining$1 = leaderPartitionsRemaining$1;
                        this.shutdownComplete$1 = shutdownComplete$1;
                    }
                });
                v0 = var9_19 = shutdownComplete;
                if (zkClient == null) ** GOTO lbl54
                {
                    catch (Throwable var3_22) {
                        this.error((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Operation failed due to controller failure";
                            }
                        }, (Function0<Throwable>)new Serializable(var3_22){
                            public static final long serialVersionUID = 0L;
                            private final Throwable t$1;

                            public final Throwable apply() {
                                return this.t$1;
                            }
                            {
                                this.t$1 = t$1;
                            }
                        });
                        v0 = false;
                    }
                }
                zkClient.close();
                break block10;
            }
            try {
                v1 = None$.MODULE$;
                var17_20 = var12_9;
                if (!(v1 != null ? v1.equals(var17_20) == false : var17_20 != null)) {
                    throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger((int)var5_3)})));
                }
                throw new MatchError(var12_9);
lbl45:
                // 1 sources

                v2 = None$.MODULE$;
                var23_21 = var6_4;
                if (!(v2 != null ? v2.equals(var23_21) == false : var23_21 != null)) {
                    throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger((int)var5_3)})));
                }
                throw new MatchError(var6_4);
            }
            finally {
                if (zkClient != null) {
                    zkClient.close();
                }
            }
        }
        return v0;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> brokerOpt = parser.accepts("broker", "REQUIRED: The broker to shutdown.").withRequiredArg().describedAs("Broker Id").ofType(Integer.class);
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> numRetriesOpt = parser.accepts("num.retries", "Number of attempts to retry if shutdown does not complete.").withRequiredArg().describedAs("number of retries").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> retryIntervalOpt = parser.accepts("retry.interval.ms", "Retry interval if retries requested.").withRequiredArg().describedAs("retry interval in ms (> 1000)").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerOpt, zkConnectOpt}));
        int retryIntervalMs = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(options.valueOf(retryIntervalOpt)), 1000);
        int numRetries = options.valueOf(numRetriesOpt);
        ShutdownBroker.ShutdownParams shutdownParams = new ShutdownBroker.ShutdownParams(options.valueOf(zkConnectOpt), options.valueOf(brokerOpt));
        if (!this.kafka$admin$ShutdownBroker$$invokeShutdown(shutdownParams)) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRetries).takeWhile((Function1)((Object)new Serializable(retryIntervalMs, shutdownParams){
                public static final long serialVersionUID = 0L;
                private final int retryIntervalMs$1;
                private final ShutdownBroker.ShutdownParams shutdownParams$1;

                public final boolean apply(int attempt) {
                    return this.apply$mcZI$sp(attempt);
                }

                public boolean apply$mcZI$sp(int attempt) {
                    ShutdownBroker$.MODULE$.info((Function0<String>)((Object)new Serializable(this, attempt){
                        public static final long serialVersionUID = 0L;
                        private final int attempt$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Retry ").append(BoxesRunTime.boxToInteger(this.attempt$1)).toString();
                        }
                        {
                            this.attempt$1 = attempt$1;
                        }
                    }));
                    try {
                        Thread.sleep(this.retryIntervalMs$1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return !ShutdownBroker$.MODULE$.kafka$admin$ShutdownBroker$$invokeShutdown(this.shutdownParams$1);
                }
                {
                    this.retryIntervalMs$1 = retryIntervalMs$1;
                    this.shutdownParams$1 = shutdownParams$1;
                }
            }));
        }
    }

    private ShutdownBroker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

