/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import java.util.Map;
import java.util.Properties;

public class MultiLruCache
extends BaseCache {
    public static final int LRU_HEAD = 0;
    public static final int LRU_TAIL = 1;
    public static final int DEFAULT_HASHTABLE_SEGMENT_SIZE = 4096;
    int segmentSize;
    LruCacheItem[][] lists;
    protected int[] listsLength;
    int trimCount;
    int trimIndex;
    Object trimIndexLk = new Object();

    public void init(int maxCapacity, Properties props) throws Exception {
        String prop;
        super.init(maxCapacity, props);
        this.segmentSize = 4096;
        if (props != null && (prop = props.getProperty("MultiLRUSegmentSize")) != null) {
            try {
                this.segmentSize = Integer.parseInt(prop);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        int segments = this.maxBuckets / this.segmentSize + (this.maxBuckets % this.segmentSize != 0 ? 1 : 0);
        this.lists = new LruCacheItem[segments][2];
        this.listsLength = new int[this.lists.length];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i][0] = null;
            this.lists[i][1] = null;
            this.listsLength[i] = 0;
        }
    }

    private LruCacheItem[] getLRUList(int index2) {
        int segment = index2 / this.segmentSize;
        return this.lists[segment];
    }

    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value2, int size2) {
        return new LruCacheItem(hashCode, key, value2, size2);
    }

    protected BaseCache.CacheItem trimLru(int segment) {
        LruCacheItem[] list2 = this.lists[segment];
        LruCacheItem l = null;
        l = list2[1];
        list2[1] = l.lPrev;
        list2[1].lNext = null;
        l.lPrev = null;
        int n = segment;
        this.listsLength[n] = this.listsLength[n] - 1;
        l.isTrimmed = true;
        ++this.trimCount;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        LruCacheItem[] list2;
        BaseCache.CacheItem overflow = null;
        LruCacheItem lc = (LruCacheItem)item;
        int index2 = this.getIndex(item.hashCode());
        int segment = index2 / this.segmentSize;
        LruCacheItem[] lruCacheItemArray = list2 = this.lists[segment];
        synchronized (list2) {
            if (list2[0] != null) {
                list2[0].lPrev = lc;
                lc.lNext = list2[0];
            } else {
                list2[1] = lc;
            }
            list2[0] = lc;
            int n = segment;
            this.listsLength[n] = this.listsLength[n] + 1;
            if (this.isThresholdReached()) {
                overflow = this.trimLru(this.trimIndex);
                this.incrementTrimIndex();
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return overflow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem item) {
        int index2 = this.getIndex(item.hashCode());
        int segment = index2 / this.segmentSize;
        LruCacheItem[] list2 = this.lists[segment];
        LruCacheItem lc = (LruCacheItem)item;
        LruCacheItem[] lruCacheItemArray = list2;
        synchronized (list2) {
            LruCacheItem prev = lc.lPrev;
            LruCacheItem next2 = lc.lNext;
            if (prev != null) {
                lc.lPrev = null;
                lc.lNext = list2[0];
                list2[0].lPrev = lc;
                list2[0] = lc;
                prev.lNext = next2;
                if (next2 != null) {
                    next2.lPrev = prev;
                } else {
                    list2[1] = prev;
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        this.itemAccessed(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem item) {
        LruCacheItem[] list2;
        LruCacheItem l = (LruCacheItem)item;
        int index2 = this.getIndex(item.hashCode());
        int segment = index2 / this.segmentSize;
        LruCacheItem[] lruCacheItemArray = list2 = this.lists[segment];
        synchronized (list2) {
            if (l.isTrimmed) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            LruCacheItem prev = l.lPrev;
            LruCacheItem next2 = l.lNext;
            if (prev != null) {
                prev.lNext = next2;
            } else {
                list2[0] = next2;
            }
            if (next2 != null) {
                next2.lPrev = prev;
            } else {
                list2[1] = prev;
            }
            int n = segment;
            this.listsLength[n] = this.listsLength[n] - 1;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    protected void handleOverflow() {
        Object l = null;
    }

    int getListsLength() {
        return this.lists.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementTrimIndex() {
        Object object = this.trimIndexLk;
        synchronized (object) {
            this.trimIndex = (this.trimIndex + 1) % this.lists.length;
        }
    }

    public Object getStatByName(String key) {
        Integer[] stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.MultiLruCache.stat_segmentSize")) {
                stat = this.segmentSize;
            } else if (key.equals("cache.MultiLruCache.stat_trimCount")) {
                stat = this.trimCount;
            } else if (key.equals("cache.MultiLruCache.stat_segmentListLength")) {
                stat = new Integer[this.lists.length];
                for (int i = 0; i < this.lists.length; ++i) {
                    stat[i] = this.listsLength[i];
                }
            }
        }
        return stat;
    }

    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.MultiLruCache.stat_segmentSize", this.segmentSize);
        for (int i = 0; i < this.lists.length; ++i) {
            stats.put("cache.MultiLruCache.stat_segmentListLength[" + i + "]:", this.listsLength[i]);
        }
        stats.put("cache.MultiLruCache.stat_trimCount", this.trimCount);
        return stats;
    }

    static class LruCacheItem
    extends BaseCache.CacheItem {
        LruCacheItem lNext;
        LruCacheItem lPrev;
        boolean isTrimmed;

        LruCacheItem(int hashCode, Object key, Object value2, int size2) {
            super(hashCode, key, value2, size2);
        }
    }
}

