/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class LruCache
extends BaseCache {
    public static final long NO_TIMEOUT = -1L;
    protected LruCacheItem head;
    protected LruCacheItem tail;
    protected int trimCount;
    protected int listSize;
    protected long timeout = -1L;
    protected int defaultMaxEntries = 8192;
    protected boolean isUnbounded = false;

    public LruCache() {
    }

    public LruCache(int defaultMaxEntries) {
        this.defaultMaxEntries = defaultMaxEntries;
    }

    public void init(int maxEntries, long timeout, float loadFactor, Properties props) {
        if (maxEntries <= 0) {
            maxEntries = this.defaultMaxEntries;
            this.isUnbounded = true;
        }
        this.setTimeout(timeout);
        super.init(maxEntries, loadFactor, props);
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.timeout = timeout;
        }
    }

    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value2, int size2) {
        return new LruCacheItem(hashCode, key, value2, size2);
    }

    protected BaseCache.CacheItem trimLru(long currentTime) {
        LruCacheItem trimItem = this.tail;
        if (this.tail != this.head) {
            this.tail = trimItem.lPrev;
            if (this.tail == null) {
                this.head = null;
                this.tail = null;
            } else {
                this.tail.lNext = null;
                trimItem.lPrev = null;
            }
        } else {
            this.head = null;
            this.tail = null;
        }
        if (trimItem != null) {
            trimItem.isTrimmed = true;
            trimItem.lPrev = null;
            ++this.trimCount;
            --this.listSize;
        }
        return trimItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        boolean updateThreshold = false;
        BaseCache.CacheItem overflow = null;
        LruCacheItem lc = (LruCacheItem)item;
        lc.lastAccessed = System.currentTimeMillis();
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (this.head != null) {
                this.head.lPrev = lc;
                lc.lNext = this.head;
                lc.lPrev = null;
                this.head = lc;
            } else {
                this.head = this.tail = lc;
                lc.lNext = null;
                lc.lPrev = null;
            }
            ++this.listSize;
            if (this.isThresholdReached()) {
                if (!this.isUnbounded) {
                    overflow = this.trimLru(lc.lastAccessed);
                } else {
                    updateThreshold = true;
                }
            }
        }
        if (updateThreshold) {
            super.handleOverflow();
        }
        return overflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem item) {
        LruCacheItem lc = (LruCacheItem)item;
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (lc.isTrimmed) {
                return;
            }
            lc.lastAccessed = System.currentTimeMillis();
            LruCacheItem prev = lc.lPrev;
            LruCacheItem next2 = lc.lNext;
            if (prev != null) {
                lc.lPrev = null;
                lc.lNext = this.head;
                this.head.lPrev = lc;
                this.head = lc;
                prev.lNext = next2;
                if (next2 != null) {
                    next2.lPrev = prev;
                } else {
                    this.tail = prev;
                }
            }
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        this.itemAccessed(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem item) {
        LruCacheItem l = (LruCacheItem)item;
        LruCache lruCache = this;
        synchronized (lruCache) {
            LruCacheItem prev = l.lPrev;
            LruCacheItem next2 = l.lNext;
            if (l.isTrimmed) {
                return;
            }
            if (prev != null) {
                prev.lNext = next2;
            } else {
                this.head = next2;
            }
            if (next2 != null) {
                next2.lPrev = prev;
            } else {
                this.tail = prev;
            }
            l.lNext = null;
            l.lPrev = null;
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimExpiredEntries(int maxCount) {
        long currentTime = System.currentTimeMillis();
        ArrayList<LruCacheItem> list2 = new ArrayList<LruCacheItem>();
        LruCache lruCache = this;
        synchronized (lruCache) {
            int count2;
            LruCacheItem item = this.tail;
            for (count2 = 0; item != null && count2 < maxCount && this.timeout != -1L && item.lastAccessed + this.timeout <= currentTime; ++count2) {
                item.isTrimmed = true;
                list2.add(item);
                item = item.lPrev;
            }
            if (item != this.tail) {
                if (item != null) {
                    item.lNext = null;
                } else {
                    this.head = null;
                }
                this.tail = item;
            }
            this.listSize -= count2;
            this.trimCount += count2;
        }
        for (int index2 = list2.size() - 1; index2 >= 0; --index2) {
            this.trimItem((LruCacheItem)list2.get(index2));
        }
    }

    public Object getStatByName(String key) {
        Object stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.LruCache.stat_lruListLength")) {
                stat = this.listSize;
            } else if (key.equals("cache.LruCache.stat_trimCount")) {
                stat = this.trimCount;
            }
        }
        return stat;
    }

    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.LruCache.stat_lruListLength", this.listSize);
        stats.put("cache.LruCache.stat_trimCount", this.trimCount);
        return stats;
    }

    protected static class LruCacheItem
    extends BaseCache.CacheItem {
        protected LruCacheItem lNext;
        protected LruCacheItem lPrev;
        protected boolean isTrimmed;
        protected long lastAccessed;

        protected LruCacheItem(int hashCode, Object key, Object value2, int size2) {
            super(hashCode, key, value2, size2);
        }
    }
}

