/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.MultiLruCache;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class BoundedMultiLruCache
extends MultiLruCache {
    protected long maxSize = Long.MAX_VALUE;
    protected long currentSize;
    private Object currentSizeLk = new Object();

    public void init(int maxCapacity, Properties props) throws Exception {
        super.init(maxCapacity, props);
        this.currentSize = 0L;
        if (props != null) {
            String strMaxSize = props.getProperty("MaxSize");
            int multiplier = 1;
            long size2 = -1L;
            String prop = strMaxSize;
            if (prop != null) {
                int index2 = (prop = prop.toUpperCase()).indexOf("KB");
                if (index2 != -1) {
                    multiplier = 1024;
                    prop = prop.substring(0, index2);
                } else {
                    index2 = prop.indexOf("MB");
                    if (index2 != -1) {
                        multiplier = 0x100000;
                        prop = prop.substring(0, index2);
                    }
                }
                try {
                    size2 = Long.parseLong(prop.trim());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (size2 > 0L) {
                this.maxSize = size2 * (long)multiplier;
            } else {
                String msg = _rb.getString("cache.BoundedMultiLruCache.illegalMaxSize");
                Object[] params = new Object[]{strMaxSize};
                msg = MessageFormat.format(msg, params);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        MultiLruCache.LruCacheItem overflow = (MultiLruCache.LruCacheItem)super.itemAdded(item);
        if (overflow != null) {
            this.decrementCurrentSize(overflow.getSize());
        }
        this.incrementCurrentSize(item.getSize());
        return overflow;
    }

    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        super.itemRefreshed(item, oldSize);
        this.decrementCurrentSize(oldSize);
        this.incrementCurrentSize(item.getSize());
    }

    protected void itemRemoved(BaseCache.CacheItem item) {
        super.itemRemoved(item);
        this.decrementCurrentSize(item.getSize());
    }

    protected boolean isThresholdReached() {
        return this.currentSize > this.maxSize || super.isThresholdReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void incrementCurrentSize(int size2) {
        Object object = this.currentSizeLk;
        synchronized (object) {
            this.currentSize += (long)size2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decrementCurrentSize(int size2) {
        Object object = this.currentSizeLk;
        synchronized (object) {
            this.currentSize -= (long)size2;
        }
    }

    public Object getStatByName(String key) {
        Object stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.BoundedMultiLruCache.stat_currentSize")) {
                stat = this.currentSize;
            } else if (key.equals("cache.BoundedMultiLruCache.stat_maxSize")) {
                stat = this.maxSize == Long.MAX_VALUE ? "default" : Long.valueOf(this.maxSize);
            }
        }
        return stat;
    }

    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.BoundedMultiLruCache.stat_currentSize", this.currentSize);
        if (this.maxSize == Long.MAX_VALUE) {
            stats.put("cache.BoundedMultiLruCache.stat_maxSize", "default");
        } else {
            stats.put("cache.BoundedMultiLruCache.stat_maxSize", this.maxSize);
        }
        return stats;
    }
}

