/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class ParametrizedUtils {
    public static Iterable<Object[]> crossProduct(Object[] v1, Object[] v2) {
        LinkedList<Object[]> ret = new LinkedList<Object[]>();
        for (Object o1 : v1) {
            for (Object o2 : v2) {
                ret.add(ParametrizedUtils.mergeObjects(o1, o2));
            }
        }
        return ret;
    }

    public static Iterable<Object[]> toArrayOfArrays(Object[] array) {
        LinkedList<Object[]> ret = new LinkedList<Object[]>();
        for (Object o : array) {
            ret.add(ParametrizedUtils.toArray(o));
        }
        return ret;
    }

    public static Iterable<Object[]> toArrayOfArrays(List<? extends Object> list) {
        LinkedList<Object[]> ret = new LinkedList<Object[]>();
        for (Object object : list) {
            ret.add(ParametrizedUtils.toArray(object));
        }
        return ret;
    }

    public static Object[] mergeObjects(Object o1, Object o2) {
        if (!o1.getClass().isArray() && !o2.getClass().isArray()) {
            return new Object[]{o1, o2};
        }
        Object[] a1 = ParametrizedUtils.toArray(o1);
        Object[] a2 = ParametrizedUtils.toArray(o2);
        return ArrayUtils.addAll((Object[])a1, (Object[])a2);
    }

    public static Object[] toArray(Object o) {
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }
}

