/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.utils.HdfsUtils;

public class CompressionUtils {
    private static final Logger LOG = Logger.getLogger(CompressionUtils.class);

    public static void untarStreamToDirectory(InputStream inputStream, String targetDirectory) throws IOException {
        assert (inputStream != null);
        assert (targetDirectory != null);
        LOG.info((Object)("Untaring archive to directory: " + targetDirectory));
        TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(inputStream));
        TarArchiveEntry entry = null;
        int BUFFER_SIZE = 2048;
        while ((entry = (TarArchiveEntry)in.getNextEntry()) != null) {
            int count;
            LOG.info((Object)("Untaring file: " + entry.getName()));
            if (entry.isDirectory()) {
                new File(HdfsUtils.joinPathFragments(targetDirectory, entry.getName())).mkdirs();
                continue;
            }
            byte[] data = new byte[BUFFER_SIZE];
            FileOutputStream fos = new FileOutputStream(HdfsUtils.joinPathFragments(targetDirectory, entry.getName()));
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER_SIZE);
            while ((count = in.read(data, 0, BUFFER_SIZE)) != -1) {
                dest.write(data, 0, count);
            }
            dest.close();
        }
        in.close();
    }

    private CompressionUtils() {
    }
}

