/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.test.asserts.HdfsAsserts;
import org.apache.sqoop.test.hadoop.HadoopLocalRunner;
import org.apache.sqoop.test.hadoop.HadoopRunner;
import org.apache.sqoop.test.hadoop.HadoopRunnerFactory;
import org.apache.sqoop.test.minicluster.SqoopMiniCluster;
import org.apache.sqoop.test.minicluster.TomcatSqoopMiniCluster;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.testng.ITest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public abstract class TomcatTestCase {
    private static final Logger LOG = Logger.getLogger(TomcatTestCase.class);
    public String name;
    protected static final String TMP_PATH_BASE = System.getProperty("sqoop.integration.tmpdir", System.getProperty("java.io.tmpdir", "/tmp")) + "/sqoop-cargo-tests/";
    private String tmpPath;
    protected static HadoopRunner hadoopCluster;
    protected static FileSystem hdfsClient;
    private TomcatSqoopMiniCluster cluster;
    private SqoopClient client;

    @BeforeSuite(alwaysRun=true)
    public static void startHadoop() throws Exception {
        hadoopCluster = HadoopRunnerFactory.getHadoopCluster(System.getProperties(), HadoopLocalRunner.class);
        hadoopCluster.setTemporaryPath(TMP_PATH_BASE);
        hadoopCluster.setConfiguration(hadoopCluster.prepareConfiguration((Configuration)new JobConf()));
        hadoopCluster.start();
        hdfsClient = FileSystem.get((Configuration)hadoopCluster.getConfiguration());
        LOG.debug((Object)("HDFS Client: " + hdfsClient));
    }

    @BeforeMethod(alwaysRun=true)
    public void findMethodName(Method method) {
        this.name = this instanceof ITest ? ((ITest)this).getTestName() : method.getName();
    }

    @BeforeMethod(alwaysRun=true)
    public void startServer() throws Exception {
        this.tmpPath = HdfsUtils.joinPathFragments(TMP_PATH_BASE, this.getClass().getName(), this.name);
        FileUtils.deleteDirectory((File)new File(this.tmpPath));
        LOG.debug((Object)("Temporary Directory: " + this.tmpPath));
        this.cluster = this.createSqoopMiniCluster();
        this.cluster.start();
        this.client = new SqoopClient(this.getServerUrl());
    }

    @AfterMethod(alwaysRun=true)
    public void stopServer() throws Exception {
        this.cluster.stop();
    }

    @AfterSuite(alwaysRun=true)
    public static void stopHadoop() throws Exception {
        hadoopCluster.stop();
    }

    public TomcatSqoopMiniCluster createSqoopMiniCluster() throws Exception {
        return new TomcatSqoopMiniCluster(this.getSqoopMiniClusterTemporaryPath(), hadoopCluster.getConfiguration());
    }

    public SqoopClient getClient() {
        return this.client;
    }

    public SqoopMiniCluster getCluster() {
        return this.cluster;
    }

    public String getTemporaryPath() {
        return this.tmpPath;
    }

    public String getSqoopMiniClusterTemporaryPath() {
        return HdfsUtils.joinPathFragments(this.tmpPath, "sqoop-mini-cluster");
    }

    public String getServerUrl() {
        return this.cluster.getServerUrl();
    }

    public String getMapreduceDirectory() {
        return HdfsUtils.joinPathFragments(hadoopCluster.getTestDirectory(), this.getClass().getName(), this.name);
    }

    protected void assertTo(String ... lines) throws IOException {
        HdfsAsserts.assertMapreduceOutput(hdfsClient, this.getMapreduceDirectory(), lines);
    }

    protected void assertToFiles(int expectedFiles) throws IOException {
        HdfsAsserts.assertMapreduceOutputFiles(hdfsClient, this.getMapreduceDirectory(), expectedFiles);
    }

    protected void createFromFile(String filename, String ... lines) throws IOException {
        HdfsUtils.createFile(hdfsClient, HdfsUtils.joinPathFragments(this.getMapreduceDirectory(), filename), lines);
    }
}

