/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.db.HiveProvider;
import org.apache.sqoop.test.hive.HiveServerRunner;
import org.apache.sqoop.test.hive.HiveServerRunnerFactory;
import org.apache.sqoop.test.hive.InternalHiveServerRunner;
import org.apache.sqoop.test.hive.InternalMetastoreServerRunner;
import org.apache.sqoop.test.hive.MetastoreServerRunner;
import org.apache.sqoop.test.hive.MetastoreServerRunnerFactory;
import org.apache.sqoop.test.testcases.ConnectorTestCase;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class HiveConnectorTestCase
extends ConnectorTestCase {
    private static final Logger LOG = Logger.getLogger(HiveConnectorTestCase.class);
    protected HiveServerRunner hiveServerRunner;
    protected MetastoreServerRunner metastoreServerRunner;
    protected HiveProvider hiveProvider;

    private void ensureWarehouseDirectory(Configuration conf) throws Exception {
        String warehouseDirectory = conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
        StringBuilder dir = new StringBuilder();
        for (String part : warehouseDirectory.split("/")) {
            dir.append(part).append("/");
            Path path = new Path(dir.toString());
            if (hdfsClient.exists(path)) continue;
            hdfsClient.mkdirs(path);
        }
        hdfsClient.setPermission(new Path(dir.toString()), new FsPermission(1023));
    }

    @BeforeMethod(alwaysRun=true)
    public void startHive() throws Exception {
        String databasePath = HdfsUtils.joinPathFragments(this.getTemporaryPath(), "metastore_db");
        this.metastoreServerRunner = MetastoreServerRunnerFactory.getRunner(System.getProperties(), InternalMetastoreServerRunner.class);
        this.metastoreServerRunner.setConfiguration(this.metastoreServerRunner.prepareConfiguration(hadoopCluster.getConfiguration()));
        this.metastoreServerRunner.getConfiguration().set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:;databaseName=" + databasePath + ";create=true");
        this.ensureWarehouseDirectory((Configuration)this.metastoreServerRunner.getConfiguration());
        LOG.info((Object)("Starting Metastore Server: " + this.metastoreServerRunner.getClass().getName()));
        this.metastoreServerRunner.start();
        this.hiveServerRunner = HiveServerRunnerFactory.getRunner(System.getProperties(), InternalHiveServerRunner.class);
        this.hiveServerRunner.setConfiguration(this.hiveServerRunner.prepareConfiguration((Configuration)this.metastoreServerRunner.getConfiguration()));
        LOG.info((Object)("Starting Hive Server: " + this.hiveServerRunner.getClass().getName()));
        this.hiveServerRunner.start();
        LOG.info((Object)("Starting Hive Provider: " + provider.getClass().getName()));
        this.hiveProvider = new HiveProvider(this.hiveServerRunner.getUrl());
        this.hiveProvider.start();
    }

    @AfterMethod(alwaysRun=true)
    public void stopHive() throws Exception {
        LOG.info((Object)("Stopping Hive Provider: " + provider.getClass().getName()));
        this.hiveProvider.stop();
        LOG.info((Object)("Stopping Hive Server: " + this.hiveServerRunner.getClass().getName()));
        this.hiveServerRunner.stop();
        LOG.info((Object)("Stopping Metastore Server: " + this.metastoreServerRunner.getClass().getName()));
        this.metastoreServerRunner.stop();
    }
}

