/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SubmissionCallback;
import org.apache.sqoop.common.test.asserts.ProviderAsserts;
import org.apache.sqoop.common.test.db.DatabaseProvider;
import org.apache.sqoop.common.test.db.DatabaseProviderFactory;
import org.apache.sqoop.common.test.db.TableName;
import org.apache.sqoop.connector.hdfs.configuration.ToFormat;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.test.data.Cities;
import org.apache.sqoop.test.data.ShortStories;
import org.apache.sqoop.test.data.UbuntuReleases;
import org.apache.sqoop.test.hadoop.HadoopMiniClusterRunner;
import org.apache.sqoop.test.hadoop.HadoopRunnerFactory;
import org.apache.sqoop.test.testcases.TomcatTestCase;
import org.apache.sqoop.validation.Status;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

public abstract class ConnectorTestCase
extends TomcatTestCase {
    private static final Logger LOG = Logger.getLogger(ConnectorTestCase.class);
    protected static DatabaseProvider provider;
    protected static SubmissionCallback DEFAULT_SUBMISSION_CALLBACKS;

    @BeforeSuite(alwaysRun=true)
    public static void startHadoop() throws Exception {
        hadoopCluster = HadoopRunnerFactory.getHadoopCluster(System.getProperties(), HadoopMiniClusterRunner.class);
        hadoopCluster.setTemporaryPath(TMP_PATH_BASE);
        hadoopCluster.setConfiguration(hadoopCluster.prepareConfiguration((Configuration)new JobConf()));
        hadoopCluster.start();
        hdfsClient = FileSystem.get((Configuration)hadoopCluster.getConfiguration());
        LOG.debug((Object)("HDFS Client: " + hdfsClient));
    }

    @BeforeClass(alwaysRun=true)
    public static void startProvider() throws Exception {
        provider = DatabaseProviderFactory.getProvider((Properties)System.getProperties());
        LOG.info((Object)("Starting database provider: " + provider.getClass().getName()));
        provider.start();
    }

    @AfterClass(alwaysRun=true)
    public static void stopProvider() {
        LOG.info((Object)("Stopping database provider: " + provider.getClass().getName()));
        provider.stop();
    }

    public TableName getTableName() {
        return new TableName(this.getClass().getSimpleName());
    }

    protected void createTable(String primaryKey, String ... columns) {
        provider.createTable(this.getTableName(), primaryKey, columns);
    }

    protected void dropTable() {
        provider.dropTable(this.getTableName());
    }

    protected void insertRow(Object ... values) {
        provider.insertRow(this.getTableName(), values);
    }

    protected void insertRow(Boolean escapeValues, Object ... values) {
        provider.insertRow(this.getTableName(), escapeValues.booleanValue(), values);
    }

    protected long rowCount() {
        return provider.rowCount(this.getTableName());
    }

    protected void dumpTable() {
        provider.dumpTable(this.getTableName());
    }

    protected void fillRdbmsLinkConfig(MLink link) {
        MLinkConfig configs = link.getConnectorLinkConfig();
        configs.getStringInput("linkConfig.jdbcDriver").setValue((Object)provider.getJdbcDriver());
        configs.getStringInput("linkConfig.connectionString").setValue((Object)provider.getConnectionUrl());
        configs.getStringInput("linkConfig.username").setValue((Object)provider.getConnectionUsername());
        configs.getStringInput("linkConfig.password").setValue((Object)provider.getConnectionPassword());
    }

    protected void fillRdbmsFromConfig(MJob job, String partitionColumn) {
        MFromConfig fromConfig = job.getFromJobConfig();
        fromConfig.getStringInput("fromJobConfig.tableName").setValue((Object)provider.escapeTableName(this.getTableName().getTableName()));
        fromConfig.getStringInput("fromJobConfig.partitionColumn").setValue((Object)provider.escapeColumnName(partitionColumn));
    }

    protected void fillRdbmsToConfig(MJob job) {
        MToConfig toConfig = job.getToJobConfig();
        toConfig.getStringInput("toJobConfig.tableName").setValue((Object)provider.escapeTableName(this.getTableName().getTableName()));
    }

    protected void fillHdfsLink(MLink link) {
        MLinkConfig configs = link.getConnectorLinkConfig();
        configs.getStringInput("linkConfig.confDir").setValue((Object)this.getCluster().getConfigurationPath());
    }

    protected void fillHdfsToConfig(MJob job, ToFormat output) {
        MToConfig toConfig = job.getToJobConfig();
        toConfig.getEnumInput("toJobConfig.outputFormat").setValue((Enum)output);
        toConfig.getStringInput("toJobConfig.outputDirectory").setValue((Object)this.getMapreduceDirectory());
    }

    protected void fillHdfsFromConfig(MJob job) {
        MFromConfig fromConfig = job.getFromJobConfig();
        fromConfig.getStringInput("fromJobConfig.inputDirectory").setValue((Object)this.getMapreduceDirectory());
    }

    protected void fillDriverConfig(MJob job) {
        job.getDriverConfig().getStringInput("throttlingConfig.numExtractors").setValue((Object)"3");
    }

    protected void createTableCities() {
        new Cities(provider, this.getTableName()).createTables();
    }

    protected void createAndLoadTableCities() {
        new Cities(provider, this.getTableName()).createTables().loadBasicData();
    }

    protected void createTableUbuntuReleases() {
        new UbuntuReleases(provider, this.getTableName()).createTables();
    }

    protected void createAndLoadTableUbuntuReleases() {
        new UbuntuReleases(provider, this.getTableName()).createTables().loadBasicData();
    }

    protected void createTableShortStories() {
        new ShortStories(provider, this.getTableName()).createTables();
    }

    protected void createAndLoadTableShortStories() {
        new ShortStories(provider, this.getTableName()).createTables().loadBasicData();
    }

    protected void assertRow(Object[] conditions, Object ... values) {
        ProviderAsserts.assertRow((DatabaseProvider)provider, (TableName)this.getTableName(), (Object[])conditions, (Object[])values);
    }

    protected void assertRow(Object[] conditions, Boolean escapeValues, Object ... values) {
        ProviderAsserts.assertRow((DatabaseProvider)provider, (TableName)this.getTableName(), (boolean)escapeValues, (Object[])conditions, (Object[])values);
    }

    protected void assertRowInCities(Object ... values) {
        this.assertRow(new Object[]{"id", values[0]}, values);
    }

    protected void saveLink(MLink link) {
        AssertJUnit.assertEquals((Object)Status.OK, (Object)this.getClient().saveLink(link));
        Assert.assertNotSame((Object)-1L, (Object)link.getPersistenceId());
    }

    protected void saveJob(MJob job) {
        AssertJUnit.assertEquals((Object)Status.OK, (Object)this.getClient().saveJob(job));
        Assert.assertNotSame((Object)-1L, (Object)job.getPersistenceId());
    }

    protected void executeJob(long jid) throws Exception {
        MSubmission finalSubmission = this.getClient().startJob(jid, DEFAULT_SUBMISSION_CALLBACKS, 100L);
        if (finalSubmission.getStatus().isFailure()) {
            LOG.error((Object)("Submission has failed: " + finalSubmission.getError().getErrorSummary()));
            LOG.error((Object)("Corresponding error details: " + finalSubmission.getError().getErrorDetails()));
        }
        AssertJUnit.assertEquals((String)("Submission finished with error: " + finalSubmission.getError().getErrorSummary()), (Object)SubmissionStatus.SUCCEEDED, (Object)finalSubmission.getStatus());
    }

    protected void executeJob(MJob job) throws Exception {
        this.executeJob(job.getPersistenceId());
    }

    static {
        DEFAULT_SUBMISSION_CALLBACKS = new SubmissionCallback(){

            public void submitted(MSubmission submission) {
                LOG.info((Object)("Submission submitted: " + submission));
            }

            public void updated(MSubmission submission) {
                LOG.info((Object)("Submission updated: " + submission));
            }

            public void finished(MSubmission submission) {
                LOG.info((Object)("Submission finished: " + submission));
            }
        };
    }
}

