/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.minicluster;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.utils.NetworkUtils;
import org.apache.sqoop.test.minicluster.SqoopMiniCluster;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;

public class TomcatSqoopMiniCluster
extends SqoopMiniCluster {
    private InstalledLocalContainer container = null;
    private Integer port = NetworkUtils.findAvailablePort();
    private static final Logger LOG = Logger.getLogger(TomcatSqoopMiniCluster.class);

    public TomcatSqoopMiniCluster(String temporaryPath) throws Exception {
        super(temporaryPath);
    }

    public TomcatSqoopMiniCluster(String temporaryPath, org.apache.hadoop.conf.Configuration configuration) throws Exception {
        super(temporaryPath, configuration);
    }

    @Override
    public void start() throws Exception {
        String[] classpath;
        if (this.container != null) {
            return;
        }
        this.prepareTemporaryPath();
        ZipURLInstaller installer = new ZipURLInstaller(new URL("http://archive.apache.org/dist/tomcat/tomcat-6/v6.0.36/bin/apache-tomcat-6.0.36.zip"));
        installer.install();
        LocalConfiguration configuration = (LocalConfiguration)new DefaultConfigurationFactory().createConfiguration("tomcat6x", ContainerType.INSTALLED, ConfigurationType.STANDALONE);
        this.container = (InstalledLocalContainer)new DefaultContainerFactory().createContainer("tomcat6x", ContainerType.INSTALLED, (Configuration)configuration);
        this.container.setHome(installer.getHome());
        this.container.setOutput(this.getTemporaryPath() + "/log/tomcat.log");
        HashMap<Object, Object> map = new HashMap<Object, Object>(System.getProperties());
        this.container.setSystemProperties(map);
        LinkedList<String> extraClassPath = new LinkedList<String>();
        for (String jar : classpath = System.getProperty("java.class.path").split(":")) {
            if (!jar.contains("hadoop-") && !jar.contains("hive-") && !jar.contains("commons-") && !jar.contains("httpcore-") && !jar.contains("httpclient-") && !jar.contains("htrace-") && !jar.contains("zookeeper-") && !jar.contains("curator-") && !jar.contains("log4j-") && !jar.contains("slf4j-") && !jar.contains("jackson-") && !jar.contains("derby") && !jar.contains("avro-") && !jar.contains("parquet-") && !jar.contains("mysql") && !jar.contains("postgre") && !jar.contains("oracle") && !jar.contains("terajdbc") && !jar.contains("tdgs") && !jar.contains("nzjdbc") && !jar.contains("sqljdbc") && !jar.contains("libfb303") && !jar.contains("datanucleus-") && !jar.contains("google")) continue;
            extraClassPath.add(jar);
        }
        this.container.setExtraClasspath(extraClassPath.toArray(new String[extraClassPath.size()]));
        configuration.addDeployable((Deployable)new WAR("../server/target/sqoop.war"));
        configuration.setProperty("cargo.servlet.port", this.port.toString());
        LOG.info((Object)("Starting tomcat server on port " + this.port));
        this.container.start();
    }

    @Override
    public void stop() throws Exception {
        this.container.stop();
        this.container = null;
    }

    @Override
    protected Map<String, String> getLoggerConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.log4j.appender.file", "org.apache.log4j.RollingFileAppender");
        properties.put("org.apache.sqoop.log4j.appender.file.File", this.getLogPath() + "sqoop.log");
        properties.put("org.apache.sqoop.log4j.appender.file.MaxFileSize", "25MB");
        properties.put("org.apache.sqoop.log4j.appender.file.MaxBackupIndex", "5");
        properties.put("org.apache.sqoop.log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
        properties.put("org.apache.sqoop.log4j.appender.file.layout.ConversionPattern", "%d{ISO8601} %-5p %c{2} [%l] %m%n\\n");
        properties.put("org.apache.sqoop.log4j.debug", "true");
        properties.put("org.apache.sqoop.log4j.rootCategory", "WARN, file");
        properties.put("org.apache.sqoop.log4j.category.org.apache.sqoop", "DEBUG");
        properties.put("org.apache.sqoop.log4j.category.org.apache.derby", "INFO");
        return properties;
    }

    public String getServerUrl() {
        return "http://localhost:" + this.port + "/sqoop/";
    }
}

