/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.hive;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.utils.NetworkUtils;

public abstract class MetastoreServerRunner {
    private static final Logger LOG = Logger.getLogger(MetastoreServerRunner.class);
    private final String hostname;
    private final int port;
    private final String warehouseDirectory;
    protected HiveConf config = null;

    public MetastoreServerRunner(String hostname, int port) throws Exception {
        this.hostname = hostname;
        this.warehouseDirectory = "/user/hive/" + UUID.randomUUID();
        if (port == 0) {
            port = NetworkUtils.findAvailablePort();
        }
        LOG.info((Object)("Hive Metastore will bind to port " + port));
        this.port = port;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public String getAuthority() {
        return this.getHostName() + ":" + this.getPort();
    }

    public Configuration prepareConfiguration(Configuration config) throws Exception {
        config.set(HiveConf.ConfVars.METASTOREURIS.varname, "thrift://" + this.getHostName() + ":" + this.getPort());
        config.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, this.warehouseDirectory);
        return config;
    }

    public HiveConf getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = new HiveConf();
        this.config.addResource(config);
        this.printConfig();
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    private void printConfig() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.config.logVars(new PrintStream(baos));
        LOG.debug((Object)("Hive server runner configuration:\n" + baos.toString()));
    }
}

