/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.hive;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.test.utils.NetworkUtils;

public abstract class HiveServerRunner {
    private static final Logger LOG = Logger.getLogger(HiveServerRunner.class);
    private final String hostname;
    private final int port;
    protected HiveConf config = null;

    public HiveServerRunner(String hostname, int port) throws Exception {
        this.hostname = hostname;
        this.port = port == 0 ? NetworkUtils.findAvailablePort() : port;
        LOG.info((Object)("Hive Server will bind to port " + this.getPort()));
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public String getUrl() {
        return "jdbc:hive2://" + this.hostname + ":" + this.port + "/default";
    }

    public Configuration prepareConfiguration(Configuration config) throws Exception {
        config.set(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, this.getHostName());
        config.setInt(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, this.getPort());
        return config;
    }

    public HiveConf getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = new HiveConf();
        this.config.addResource(config);
        this.printConfig();
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    private void printConfig() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.config.logVars(new PrintStream(baos));
        LOG.debug((Object)("Hive server runner configuration:\n" + baos.toString()));
    }
}

