/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SubmissionCallback;
import org.apache.sqoop.framework.configuration.OutputFormat;
import org.apache.sqoop.framework.configuration.StorageType;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.test.asserts.ProviderAsserts;
import org.apache.sqoop.test.data.Cities;
import org.apache.sqoop.test.data.UbuntuReleases;
import org.apache.sqoop.test.db.DatabaseProvider;
import org.apache.sqoop.test.db.DatabaseProviderFactory;
import org.apache.sqoop.test.hadoop.HadoopMiniClusterRunner;
import org.apache.sqoop.test.hadoop.HadoopRunnerFactory;
import org.apache.sqoop.test.testcases.TomcatTestCase;
import org.apache.sqoop.validation.Status;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class ConnectorTestCase
extends TomcatTestCase {
    private static final Logger LOG = Logger.getLogger(ConnectorTestCase.class);
    protected static DatabaseProvider provider;
    protected static SubmissionCallback DEFAULT_SUBMISSION_CALLBACKS;

    @BeforeClass
    public static void startHadoop() throws Exception {
        hadoopCluster = HadoopRunnerFactory.getHadoopCluster(System.getProperties(), HadoopMiniClusterRunner.class);
        hadoopCluster.setTemporaryPath(TMP_PATH_BASE);
        hadoopCluster.setConfiguration(hadoopCluster.prepareConfiguration((Configuration)new JobConf()));
        hadoopCluster.start();
        hdfsClient = FileSystem.get((Configuration)hadoopCluster.getConfiguration());
        LOG.debug((Object)("HDFS Client: " + hdfsClient));
    }

    @BeforeClass
    public static void startProvider() throws Exception {
        provider = DatabaseProviderFactory.getProvider(System.getProperties());
        LOG.info((Object)("Starting database provider: " + provider.getClass().getName()));
        provider.start();
    }

    @AfterClass
    public static void stopProvider() {
        LOG.info((Object)("Stopping database provider: " + provider.getClass().getName()));
        provider.stop();
    }

    public String getTableName() {
        return this.getClass().getSimpleName();
    }

    protected void createTable(String primaryKey, String ... columns) {
        provider.createTable(this.getTableName(), primaryKey, columns);
    }

    protected void dropTable() {
        provider.dropTable(this.getTableName());
    }

    protected void insertRow(Object ... values) {
        provider.insertRow(this.getTableName(), values);
    }

    protected long rowCount() {
        return provider.rowCount(this.getTableName());
    }

    protected void fillConnectionForm(MConnection connection) {
        MConnectionForms forms = connection.getConnectorPart();
        forms.getStringInput("connection.jdbcDriver").setValue((Object)provider.getJdbcDriver());
        forms.getStringInput("connection.connectionString").setValue((Object)provider.getConnectionUrl());
        forms.getStringInput("connection.username").setValue((Object)provider.getConnectionUsername());
        forms.getStringInput("connection.password").setValue((Object)provider.getConnectionPassword());
    }

    protected void fillOutputForm(MJob job, StorageType storage, OutputFormat output) {
        MJobForms forms = job.getFrameworkPart();
        forms.getEnumInput("output.storageType").setValue((Enum)storage);
        forms.getEnumInput("output.outputFormat").setValue((Enum)output);
        forms.getStringInput("output.outputDirectory").setValue((Object)this.getMapreduceDirectory());
    }

    protected void fillInputForm(MJob job) {
        MJobForms forms = job.getFrameworkPart();
        forms.getStringInput("input.inputDirectory").setValue((Object)this.getMapreduceDirectory());
    }

    protected void createTableCities() {
        new Cities(provider, this.getTableName()).createTables();
    }

    protected void createAndLoadTableCities() {
        new Cities(provider, this.getTableName()).createTables().loadBasicData();
    }

    protected void createTableUbuntuReleases() {
        new UbuntuReleases(provider, this.getTableName()).createTables();
    }

    protected void createAndLoadTableUbuntuReleases() {
        new UbuntuReleases(provider, this.getTableName()).createTables().loadBasicData();
    }

    protected void assertRow(Object[] conditions, Object ... values) {
        ProviderAsserts.assertRow(provider, this.getTableName(), conditions, values);
    }

    protected void assertRowInCities(Object ... values) {
        this.assertRow(new Object[]{"id", values[0]}, values);
    }

    protected void createConnection(MConnection connection) {
        Assert.assertEquals((Object)Status.FINE, (Object)this.getClient().createConnection(connection));
        Assert.assertNotSame((Object)-1L, (Object)connection.getPersistenceId());
    }

    protected void createJob(MJob job) {
        Assert.assertEquals((Object)Status.FINE, (Object)this.getClient().createJob(job));
        Assert.assertNotSame((Object)-1L, (Object)job.getPersistenceId());
    }

    protected void runJob(long jid) throws Exception {
        this.getClient().startSubmission(jid, DEFAULT_SUBMISSION_CALLBACKS, 100L);
    }

    protected void runJob(MJob job) throws Exception {
        this.runJob(job.getPersistenceId());
    }

    static {
        DEFAULT_SUBMISSION_CALLBACKS = new SubmissionCallback(){

            public void submitted(MSubmission submission) {
                LOG.info((Object)("Submission submitted: " + submission));
            }

            public void updated(MSubmission submission) {
                LOG.info((Object)("Submission updated: " + submission));
            }

            public void finished(MSubmission submission) {
                LOG.info((Object)("Submission finished: " + submission));
            }
        };
    }
}

