/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.minicluster;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;

public abstract class SqoopMiniCluster {
    private Configuration configuration;
    private String temporaryPath;

    public SqoopMiniCluster(String temporaryPath) throws Exception {
        this(temporaryPath, new Configuration());
    }

    public SqoopMiniCluster(String temporaryPath, Configuration configuration) throws Exception {
        this.temporaryPath = temporaryPath;
        this.configuration = configuration;
    }

    public String getTemporaryPath() {
        return this.temporaryPath;
    }

    public String getConfigurationPath() {
        return this.temporaryPath + "/config/";
    }

    public String getLogPath() {
        return this.temporaryPath + "/log/";
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    protected void prepareTemporaryPath() throws IOException {
        File tmpDir = new File(this.getTemporaryPath());
        File configDir = new File(this.getConfigurationPath());
        File logDir = new File(this.getLogPath());
        FileUtils.deleteDirectory((File)tmpDir);
        FileUtils.forceMkdir((File)tmpDir);
        FileUtils.forceMkdir((File)configDir);
        FileUtils.forceMkdir((File)logDir);
        System.setProperty("sqoop.config.dir", this.getConfigurationPath());
        FileUtils.writeStringToFile((File)new File(this.getConfigurationPath() + "sqoop_bootstrap.properties"), (String)"sqoop.config.provider=org.apache.sqoop.core.PropertiesConfigurationProvider");
        File f = new File(this.getConfigurationPath() + "sqoop.properties");
        LinkedList<String> sqoopProperties = new LinkedList<String>();
        this.mapToProperties(sqoopProperties, this.getLoggerConfiguration());
        this.mapToProperties(sqoopProperties, this.getRepositoryConfiguration());
        this.mapToProperties(sqoopProperties, this.getSubmissionEngineConfiguration());
        this.mapToProperties(sqoopProperties, this.getExecutionEngineConfiguration());
        FileUtils.writeLines((File)f, sqoopProperties);
        FileOutputStream stream = FileUtils.openOutputStream((File)new File(this.getConfigurationPath() + "hadoop-site.xml"));
        this.configuration.writeXml((OutputStream)stream);
        ((OutputStream)stream).close();
    }

    private void mapToProperties(List<String> output, Map<String, String> input) {
        for (Map.Entry<String, String> entry : input.entrySet()) {
            output.add(entry.getKey() + "=" + entry.getValue());
        }
    }

    protected Map<String, String> getLoggerConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.log4j.appender.file", "org.apache.log4j.ConsoleAppender");
        properties.put("org.apache.sqoop.log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
        properties.put("org.apache.sqoop.log4j.appender.file.layout.ConversionPattern", "%d{ISO8601} %-5p %c{2} [%l] %m%n");
        properties.put("org.apache.sqoop.log4j.debug", "true");
        properties.put("org.apache.sqoop.log4j.rootCategory", "WARN, file");
        properties.put("org.apache.sqoop.log4j.category.org.apache.sqoop", "DEBUG");
        properties.put("org.apache.sqoop.log4j.category.org.apache.derby", "INFO");
        return properties;
    }

    protected Map<String, String> getRepositoryConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.repository.provider", "org.apache.sqoop.repository.JdbcRepositoryProvider");
        properties.put("org.apache.sqoop.repository.schema.immutable", "false");
        properties.put("org.apache.sqoop.repository.jdbc.handler", "org.apache.sqoop.repository.derby.DerbyRepositoryHandler");
        properties.put("org.apache.sqoop.repository.jdbc.transaction.isolation", "READ_COMMITTED");
        properties.put("org.apache.sqoop.repository.jdbc.maximum.connections", "10");
        properties.put("org.apache.sqoop.repository.jdbc.url=jdbc:derby:memory:myDB;create", "true");
        properties.put("org.apache.sqoop.repository.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        properties.put("org.apache.sqoop.repository.jdbc.user", "sa");
        properties.put("org.apache.sqoop.repository.jdbc.password", "");
        return properties;
    }

    protected Map<String, String> getSubmissionEngineConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.submission.engine", "org.apache.sqoop.submission.mapreduce.MapreduceSubmissionEngine");
        properties.put("org.apache.sqoop.submission.engine.mapreduce.configuration.directory", this.getConfigurationPath());
        return properties;
    }

    protected Map<String, String> getExecutionEngineConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.execution.engine", "org.apache.sqoop.execution.mapreduce.MapreduceExecutionEngine");
        return properties;
    }
}

