/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.test.asserts.HdfsAsserts;
import org.apache.sqoop.test.hadoop.HadoopLocalRunner;
import org.apache.sqoop.test.hadoop.HadoopRunner;
import org.apache.sqoop.test.hadoop.HadoopRunnerFactory;
import org.apache.sqoop.test.minicluster.TomcatSqoopMiniCluster;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class TomcatTestCase {
    private static final Logger LOG = Logger.getLogger(TomcatTestCase.class);
    @Rule
    public TestName name = new TestName();
    protected static final String TMP_PATH_BASE = System.getProperty("sqoop.integration.tmpdir", System.getProperty("java.io.tmpdir", "/tmp")) + "/sqoop-cargo-tests/";
    private String tmpPath;
    protected static HadoopRunner hadoopCluster;
    protected static FileSystem hdfsClient;
    private TomcatSqoopMiniCluster cluster;
    private SqoopClient client;

    @BeforeClass
    public static void startHadoop() throws Exception {
        hadoopCluster = HadoopRunnerFactory.getHadoopCluster(System.getProperties(), HadoopLocalRunner.class);
        hadoopCluster.setTemporaryPath(TMP_PATH_BASE);
        hadoopCluster.setConfiguration(hadoopCluster.prepareConfiguration((Configuration)new JobConf()));
        hadoopCluster.start();
        hdfsClient = FileSystem.get((Configuration)hadoopCluster.getConfiguration());
        LOG.debug((Object)("HDFS Client: " + hdfsClient));
    }

    @Before
    public void startServer() throws Exception {
        this.tmpPath = HdfsUtils.joinPathFragments(TMP_PATH_BASE, this.getClass().getName(), this.name.getMethodName());
        LOG.debug((Object)("Temporary Directory: " + this.tmpPath));
        this.cluster = new TomcatSqoopMiniCluster(this.tmpPath, hadoopCluster.getConfiguration());
        this.cluster.start();
        this.client = new SqoopClient(this.getServerUrl());
    }

    @After
    public void stopServer() throws Exception {
        this.cluster.stop();
    }

    @AfterClass
    public static void stopHadoop() throws Exception {
        hadoopCluster.stop();
    }

    public SqoopClient getClient() {
        return this.client;
    }

    public String getTemporaryPath() {
        return this.tmpPath;
    }

    public String getServerUrl() {
        return this.cluster.getServerUrl();
    }

    public String getMapreduceDirectory() {
        return HdfsUtils.joinPathFragments(hadoopCluster.getTestDirectory(), this.getClass().getName(), this.name.getMethodName());
    }

    protected void assertMapreduceOutput(String ... lines) throws IOException {
        HdfsAsserts.assertMapreduceOutput(hdfsClient, this.getMapreduceDirectory(), lines);
    }

    protected void assertMapreduceOutputFiles(int expectedFiles) throws IOException {
        HdfsAsserts.assertMapreduceOutputFiles(hdfsClient, this.getMapreduceDirectory(), expectedFiles);
    }

    protected void createInputMapreduceFile(String filename, String ... lines) throws IOException {
        HdfsUtils.createFile(hdfsClient, HdfsUtils.joinPathFragments(this.getMapreduceDirectory(), filename), lines);
    }
}

