/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.db;

import org.apache.sqoop.test.db.DatabaseProvider;

public class PostgreSQLProvider
extends DatabaseProvider {
    public static final String DRIVER = "org.postgresql.Driver";
    private static final String CONNECTION = System.getProperties().getProperty("sqoop.provider.postgresql.jdbc", "jdbc:postgresql://localhost/test");
    private static final String USERNAME = System.getProperties().getProperty("sqoop.provider.postgresql.username", "sqoop");
    private static final String PASSWORD = System.getProperties().getProperty("sqoop.provider.postgresql.password", "sqoop");

    @Override
    public String getConnectionUrl() {
        return CONNECTION;
    }

    @Override
    public String getConnectionUsername() {
        return USERNAME;
    }

    @Override
    public String getConnectionPassword() {
        return PASSWORD;
    }

    @Override
    public String escapeColumnName(String columnName) {
        return this.escape(columnName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return this.escape(tableName);
    }

    @Override
    public String escapeValueString(String value) {
        return "'" + value + "'";
    }

    @Override
    public boolean isSupportingScheme() {
        return true;
    }

    @Override
    public String getJdbcDriver() {
        return DRIVER;
    }

    public String escape(String entity) {
        return "\"" + entity + "\"";
    }
}

