/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.submission.mapreduce;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.execution.mapreduce.MRSubmissionRequest;
import org.apache.sqoop.execution.mapreduce.MapreduceExecutionEngine;
import org.apache.sqoop.framework.SubmissionEngine;
import org.apache.sqoop.framework.SubmissionRequest;
import org.apache.sqoop.job.mr.ConfigurationUtils;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counter;
import org.apache.sqoop.submission.counter.CounterGroup;
import org.apache.sqoop.submission.mapreduce.MapreduceSubmissionError;

public class MapreduceSubmissionEngine
extends SubmissionEngine {
    private static Logger LOG = Logger.getLogger(MapreduceSubmissionEngine.class);
    private Configuration globalConfiguration;
    private JobClient jobClient;

    public void initialize(MapContext context, String prefix) {
        LOG.info((Object)"Initializing Map-reduce Submission Engine");
        this.globalConfiguration = new Configuration();
        this.globalConfiguration.clear();
        String configDirectory = context.getString(prefix + "mapreduce.configuration.directory");
        File dir = new File(configDirectory);
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-site.xml");
            }
        });
        if (files == null) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0002, "Invalid Hadoop configuration directory (not a directory or permission issues): " + configDirectory);
        }
        for (String file : files) {
            LOG.info((Object)("Found hadoop configuration file " + file));
            try {
                this.globalConfiguration.addResource(new File(configDirectory, file).toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("Can't load configuration file: " + file), (Throwable)e);
            }
        }
        this.globalConfiguration.setBoolean("sqoop.job", true);
        try {
            this.jobClient = new JobClient(new JobConf(this.globalConfiguration));
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0002, (Throwable)e);
        }
        if (this.isLocal()) {
            LOG.info((Object)"Detected MapReduce local mode, some methods might not work correctly.");
        }
    }

    public void destroy() {
        LOG.info((Object)"Destroying Mapreduce Submission Engine");
        try {
            this.jobClient.close();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0005, (Throwable)e);
        }
    }

    public boolean isExecutionEngineSupported(Class executionEngineClass) {
        return executionEngineClass == MapreduceExecutionEngine.class;
    }

    public boolean submit(SubmissionRequest generalRequest) {
        MRSubmissionRequest request = (MRSubmissionRequest)generalRequest;
        Configuration configuration = new Configuration(this.globalConfiguration);
        ConfigurationUtils.setJobType((Configuration)configuration, (MJob.Type)request.getJobType());
        for (Map.Entry entry : request.getFrameworkContext()) {
            if (entry.getValue() == null) {
                LOG.warn((Object)("Ignoring null framework context value for key " + (String)entry.getKey()));
                continue;
            }
            configuration.set((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : request.getConnectorContext()) {
            if (entry.getValue() == null) {
                LOG.warn((Object)("Ignoring null connector context value for key " + (String)entry.getKey()));
                continue;
            }
            configuration.set("org.apache.sqoop.job.connector.context." + (String)entry.getKey(), (String)entry.getValue());
        }
        if (request.getNotificationUrl() != null) {
            configuration.set("job.end.notification.url", request.getNotificationUrl());
        }
        configuration.setBoolean("mapred.map.tasks.speculative.execution", false);
        configuration.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String jar : request.getJars()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            LOG.debug((Object)("Adding jar to the job: " + jar));
            sb.append(jar);
        }
        configuration.set("tmpjars", sb.toString());
        try {
            Job job = new Job(configuration);
            ConfigurationUtils.setConfigConnectorConnection((Job)job, (Object)request.getConfigConnectorConnection());
            ConfigurationUtils.setConfigConnectorJob((Job)job, (Object)request.getConfigConnectorJob());
            ConfigurationUtils.setConfigFrameworkConnection((Job)job, (Object)request.getConfigFrameworkConnection());
            ConfigurationUtils.setConfigFrameworkJob((Job)job, (Object)request.getConfigFrameworkJob());
            if (request.getJobName() != null) {
                job.setJobName("Sqoop: " + request.getJobName());
            } else {
                job.setJobName("Sqoop job with id: " + request.getJobId());
            }
            job.setInputFormatClass(request.getInputFormatClass());
            job.setMapperClass(request.getMapperClass());
            job.setMapOutputKeyClass(request.getMapOutputKeyClass());
            job.setMapOutputValueClass(request.getMapOutputValueClass());
            String outputDirectory = request.getOutputDirectory();
            if (outputDirectory != null) {
                FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDirectory));
            }
            if (request.getLoaders() != null) {
                job.setNumReduceTasks(request.getLoaders().intValue());
            } else {
                job.setNumReduceTasks(0);
            }
            job.setOutputFormatClass(request.getOutputFormatClass());
            job.setOutputKeyClass(request.getOutputKeyClass());
            job.setOutputValueClass(request.getOutputValueClass());
            if (this.isLocal()) {
                job.waitForCompletion(true);
            } else {
                job.submit();
            }
            String jobId = job.getJobID().toString();
            request.getSummary().setExternalId(jobId);
            request.getSummary().setExternalLink(job.getTrackingURL());
            LOG.debug((Object)("Executed new map-reduce job with id " + jobId));
        }
        catch (Exception e) {
            request.getSummary().setException((Throwable)e);
            LOG.error((Object)"Error in submitting job", (Throwable)e);
            return false;
        }
        return true;
    }

    public void stop(String submissionId) {
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)submissionId));
            if (runningJob == null) {
                return;
            }
            runningJob.killJob();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    public SubmissionStatus status(String submissionId) {
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)submissionId));
            if (runningJob == null) {
                return SubmissionStatus.UNKNOWN;
            }
            int status = runningJob.getJobState();
            return this.convertMapreduceState(status);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    public double progress(String submissionId) {
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)submissionId));
            if (runningJob == null) {
                return super.progress(submissionId);
            }
            return (runningJob.mapProgress() + runningJob.reduceProgress()) / 2.0f;
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    public org.apache.sqoop.submission.counter.Counters counters(String submissionId) {
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)submissionId));
            if (runningJob == null) {
                return super.counters(submissionId);
            }
            return this.convertMapreduceCounters(runningJob.getCounters());
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    public String externalLink(String submissionId) {
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)submissionId));
            if (runningJob == null) {
                return null;
            }
            return runningJob.getTrackingURL();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    protected SubmissionStatus convertMapreduceState(int status) {
        if (status == 4) {
            return SubmissionStatus.BOOTING;
        }
        if (status == 1) {
            return SubmissionStatus.RUNNING;
        }
        if (status == 3) {
            return SubmissionStatus.FAILED;
        }
        if (status == 5) {
            return SubmissionStatus.FAILED;
        }
        if (status == 2) {
            return SubmissionStatus.SUCCEEDED;
        }
        throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0004, "Unknown status " + status);
    }

    private org.apache.sqoop.submission.counter.Counters convertMapreduceCounters(Counters hadoopCounters) {
        org.apache.sqoop.submission.counter.Counters sqoopCounters = new org.apache.sqoop.submission.counter.Counters();
        if (hadoopCounters == null) {
            return sqoopCounters;
        }
        for (Counters.Group hadoopGroup : hadoopCounters) {
            CounterGroup sqoopGroup = new CounterGroup(hadoopGroup.getName());
            for (Counters.Counter hadoopCounter : hadoopGroup) {
                Counter sqoopCounter = new Counter(hadoopCounter.getName(), hadoopCounter.getValue());
                sqoopGroup.addCounter(sqoopCounter);
            }
            sqoopCounters.addCounterGroup(sqoopGroup);
        }
        return sqoopCounters;
    }

    private boolean isLocal() {
        if ("yarn".equals(this.globalConfiguration.get("mapreduce.framework.name"))) {
            return false;
        }
        return "local".equals(this.globalConfiguration.get("mapreduce.jobtracker.address")) || "local".equals(this.globalConfiguration.get("mapred.job.tracker"));
    }
}

