/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.submission.mapreduce;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.driver.JobRequest;
import org.apache.sqoop.driver.SubmissionEngine;
import org.apache.sqoop.error.code.MapreduceSubmissionError;
import org.apache.sqoop.execution.mapreduce.MRJobRequest;
import org.apache.sqoop.execution.mapreduce.MapreduceExecutionEngine;
import org.apache.sqoop.job.mr.MRConfigurationUtils;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.model.SubmissionError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.submission.SubmissionStatus;

public class MapreduceSubmissionEngine
extends SubmissionEngine {
    private static Logger LOG = Logger.getLogger(MapreduceSubmissionEngine.class);
    private Configuration globalConfiguration;
    private JobClient jobClient;

    public void initialize(MapContext context, String prefix) {
        super.initialize(context, prefix);
        LOG.info((Object)"Initializing Map-reduce Submission Engine");
        this.globalConfiguration = new Configuration();
        this.globalConfiguration.clear();
        String configDirectory = context.getString(prefix + "mapreduce.configuration.directory");
        File dir = new File(configDirectory);
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-site.xml");
            }
        });
        if (files == null) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0002, "Invalid Hadoop configuration directory (not a directory or permission issues): " + configDirectory);
        }
        for (String file : files) {
            LOG.info((Object)("Found hadoop configuration file " + file));
            try {
                this.globalConfiguration.addResource(new File(configDirectory, file).toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("Can't load configuration file: " + file), (Throwable)e);
            }
        }
        this.globalConfiguration.setBoolean("sqoop.job", true);
        try {
            this.jobClient = new JobClient(new JobConf(this.globalConfiguration));
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0002, (Throwable)e);
        }
        if (this.isLocal()) {
            LOG.info((Object)"Detected MapReduce local mode, some methods might not work correctly.");
        }
    }

    public void destroy() {
        super.destroy();
        LOG.info((Object)"Destroying Mapreduce Submission Engine");
        try {
            this.jobClient.close();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0005, (Throwable)e);
        }
    }

    public boolean isExecutionEngineSupported(Class<?> executionEngineClass) {
        return executionEngineClass == MapreduceExecutionEngine.class;
    }

    public boolean submit(JobRequest mrJobRequest) {
        MRJobRequest request = (MRJobRequest)mrJobRequest;
        Configuration configuration = new Configuration(this.globalConfiguration);
        for (Map.Entry entry : request.getDriverContext()) {
            if (entry.getValue() == null) {
                LOG.warn((Object)("Ignoring null driver context value for key " + (String)entry.getKey()));
                continue;
            }
            configuration.set((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : request.getConnectorContext(Direction.FROM)) {
            if (entry.getValue() == null) {
                LOG.warn((Object)("Ignoring null connector context value for key " + (String)entry.getKey()));
                continue;
            }
            configuration.set("org.apache.sqoop.job.connector.from.context." + (String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : request.getConnectorContext(Direction.TO)) {
            if (entry.getValue() == null) {
                LOG.warn((Object)("Ignoring null connector context value for key " + (String)entry.getKey()));
                continue;
            }
            configuration.set("org.apache.sqoop.job.connector.to.context." + (String)entry.getKey(), (String)entry.getValue());
        }
        if (request.getNotificationUrl() != null) {
            configuration.set("job.end.notification.url", request.getNotificationUrl());
        }
        configuration.setBoolean("mapred.map.tasks.speculative.execution", false);
        configuration.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        configuration.set("tmpjars", StringUtils.join((Collection)request.getJars(), (String)","));
        try {
            Job job = new Job(configuration);
            MRConfigurationUtils.setConnectorLinkConfig((Direction)Direction.FROM, (Job)job, (Object)request.getConnectorLinkConfig(Direction.FROM));
            MRConfigurationUtils.setConnectorLinkConfig((Direction)Direction.TO, (Job)job, (Object)request.getConnectorLinkConfig(Direction.TO));
            MRConfigurationUtils.setConnectorJobConfig((Direction)Direction.FROM, (Job)job, (Object)request.getJobConfig(Direction.FROM));
            MRConfigurationUtils.setConnectorJobConfig((Direction)Direction.TO, (Job)job, (Object)request.getJobConfig(Direction.TO));
            MRConfigurationUtils.setDriverConfig((Job)job, (Object)request.getDriverConfig());
            MRConfigurationUtils.setConnectorSchema((Direction)Direction.FROM, (Job)job, (Schema)request.getJobSubmission().getFromSchema());
            MRConfigurationUtils.setConnectorSchema((Direction)Direction.TO, (Job)job, (Schema)request.getJobSubmission().getToSchema());
            if (request.getJobName() != null) {
                job.setJobName("Sqoop: " + request.getJobName());
            } else {
                job.setJobName("Sqoop job with id: " + request.getJobId());
            }
            job.setInputFormatClass(request.getInputFormatClass());
            job.setMapperClass(request.getMapperClass());
            job.setMapOutputKeyClass(request.getMapOutputKeyClass());
            job.setMapOutputValueClass(request.getMapOutputValueClass());
            if (request.getLoaders() != null) {
                job.setNumReduceTasks(request.getLoaders().intValue());
            } else {
                job.setNumReduceTasks(0);
            }
            job.setOutputFormatClass(request.getOutputFormatClass());
            job.setOutputKeyClass(request.getOutputKeyClass());
            job.setOutputValueClass(request.getOutputValueClass());
            if (this.isLocal()) {
                this.submitToLocalRunner(request, job);
            } else {
                this.submitToCluster(request, job);
            }
            LOG.debug((Object)("Executed new map-reduce job with id " + job.getJobID().toString()));
        }
        catch (Exception e) {
            SubmissionError error = new SubmissionError();
            error.setErrorSummary(e.toString());
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            writer.flush();
            error.setErrorDetails(writer.toString());
            request.getJobSubmission().setError(error);
            LOG.error((Object)"Error in submitting job", (Throwable)e);
            return false;
        }
        return true;
    }

    private void submitToCluster(MRJobRequest request, Job job) throws IOException, InterruptedException, ClassNotFoundException {
        job.submit();
        request.getJobSubmission().setExternalJobId(job.getJobID().toString());
        request.getJobSubmission().setExternalLink(job.getTrackingURL());
    }

    private void submitToLocalRunner(MRJobRequest request, Job job) throws IOException, InterruptedException, ClassNotFoundException {
        boolean successful = job.waitForCompletion(true);
        if (successful) {
            request.getJobSubmission().setStatus(SubmissionStatus.SUCCEEDED);
        } else {
            request.getJobSubmission().setStatus(SubmissionStatus.FAILED);
        }
        request.getJobSubmission().setExternalJobId(job.getJobID().toString());
        request.getJobSubmission().setExternalLink(job.getTrackingURL());
        request.getJobSubmission().setStatus(this.convertMapreduceState(job.getJobState().getValue()));
        request.getJobSubmission().setError(null);
        request.getJobSubmission().setProgress((double)((job.mapProgress() + job.reduceProgress()) / 2.0f));
        request.getJobSubmission().setCounters(this.convertHadoop2MapreduceCounters(job.getCounters()));
        request.getJobSubmission().setLastUpdateDate(new Date());
    }

    public void stop(String externalJobId) {
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)externalJobId));
            if (runningJob == null) {
                return;
            }
            runningJob.killJob();
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    private SubmissionStatus status(RunningJob runningJob) {
        try {
            if (runningJob == null) {
                return SubmissionStatus.UNKNOWN;
            }
            int status = runningJob.getJobState();
            return this.convertMapreduceState(status);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    private SubmissionError error(RunningJob runningJob) {
        try {
            if (runningJob == null) {
                return null;
            }
            int status = runningJob.getJobState();
            if (status == JobStatus.FAILED || status == JobStatus.KILLED) {
                SubmissionError error = new SubmissionError();
                error.setErrorSummary("Job Failed with status:" + status);
                error.setErrorDetails(runningJob.getFailureInfo());
                return error;
            }
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
        return null;
    }

    private double progress(RunningJob runningJob) {
        try {
            if (runningJob == null) {
                return -1.0;
            }
            return (runningJob.mapProgress() + runningJob.reduceProgress()) / 2.0f;
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    private org.apache.sqoop.submission.counter.Counters counters(RunningJob runningJob) {
        try {
            if (runningJob == null) {
                return null;
            }
            return this.convertHadoop1MapreduceCounters(runningJob.getCounters());
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    private SubmissionStatus convertMapreduceState(int status) {
        if (status == JobStatus.PREP) {
            return SubmissionStatus.BOOTING;
        }
        if (status == JobStatus.RUNNING) {
            return SubmissionStatus.RUNNING;
        }
        if (status == JobStatus.FAILED) {
            return SubmissionStatus.FAILED;
        }
        if (status == JobStatus.KILLED) {
            return SubmissionStatus.FAILED;
        }
        if (status == JobStatus.SUCCEEDED) {
            return SubmissionStatus.SUCCEEDED;
        }
        throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0004, "Unknown status " + status);
    }

    private org.apache.sqoop.submission.counter.Counters convertHadoop1MapreduceCounters(org.apache.hadoop.mapred.Counters hadoopCounters) {
        org.apache.sqoop.submission.counter.Counters sqoopCounters = new org.apache.sqoop.submission.counter.Counters();
        if (hadoopCounters == null) {
            return sqoopCounters;
        }
        for (Counters.Group counterGroup : hadoopCounters) {
            org.apache.sqoop.submission.counter.CounterGroup sqoopGroup = new org.apache.sqoop.submission.counter.CounterGroup(counterGroup.getName());
            for (Counters.Counter hadoopCounter : counterGroup) {
                org.apache.sqoop.submission.counter.Counter sqoopCounter = new org.apache.sqoop.submission.counter.Counter(hadoopCounter.getName(), hadoopCounter.getValue());
                sqoopGroup.addCounter(sqoopCounter);
            }
            sqoopCounters.addCounterGroup(sqoopGroup);
        }
        return sqoopCounters;
    }

    private org.apache.sqoop.submission.counter.Counters convertHadoop2MapreduceCounters(Counters hadoopCounters) {
        org.apache.sqoop.submission.counter.Counters sqoopCounters = new org.apache.sqoop.submission.counter.Counters();
        if (hadoopCounters == null) {
            return sqoopCounters;
        }
        for (CounterGroup counterGroup : hadoopCounters) {
            org.apache.sqoop.submission.counter.CounterGroup sqoopGroup = new org.apache.sqoop.submission.counter.CounterGroup(counterGroup.getName());
            for (Counter hadoopCounter : counterGroup) {
                org.apache.sqoop.submission.counter.Counter sqoopCounter = new org.apache.sqoop.submission.counter.Counter(hadoopCounter.getName(), hadoopCounter.getValue());
                sqoopGroup.addCounter(sqoopCounter);
            }
            sqoopCounters.addCounterGroup(sqoopGroup);
        }
        return sqoopCounters;
    }

    public void update(MSubmission submission) {
        double progress = -1.0;
        org.apache.sqoop.submission.counter.Counters counters = null;
        String externalJobId = submission.getExternalJobId();
        try {
            RunningJob runningJob = this.jobClient.getJob(JobID.forName((String)externalJobId));
            SubmissionStatus newStatus = this.status(runningJob);
            SubmissionError error = this.error(runningJob);
            if (newStatus.isRunning()) {
                progress = this.progress(runningJob);
            } else {
                counters = this.counters(runningJob);
            }
            submission.setStatus(newStatus);
            submission.setError(error);
            submission.setProgress(progress);
            submission.setCounters(counters);
            submission.setLastUpdateDate(new Date());
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)MapreduceSubmissionError.MAPREDUCE_0003, (Throwable)e);
        }
    }

    private boolean isLocal() {
        if ("yarn".equals(this.globalConfiguration.get("mapreduce.framework.name"))) {
            return false;
        }
        return "local".equals(this.globalConfiguration.get("mapreduce.jobtracker.address")) || "local".equals(this.globalConfiguration.get("mapred.job.tracker"));
    }
}

