/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tools;

import java.util.Arrays;
import org.apache.sqoop.common.VersionInfo;
import org.apache.sqoop.tools.Tool;
import org.apache.sqoop.tools.tool.BuiltinTools;
import org.apache.sqoop.utils.ClassUtils;

public final class ToolRunner {
    public static void main(String[] args) throws Exception {
        System.out.println("Sqoop tool executor:");
        System.out.println("\tVersion: " + VersionInfo.getVersion());
        System.out.println("\tRevision: " + VersionInfo.getRevision());
        System.out.println("\tCompiled on " + VersionInfo.getDate() + " by " + VersionInfo.getUser());
        if (args.length < 1) {
            throw new IllegalArgumentException("Name of the tool is missing.");
        }
        Class toolClass = BuiltinTools.getTool(args[0]);
        if (toolClass == null) {
            toolClass = ClassUtils.loadClass((String)args[0]);
        }
        if (toolClass == null) {
            throw new IllegalArgumentException("Can't find tool: " + args[0]);
        }
        Tool tool = (Tool)ClassUtils.instantiate((Class)toolClass, (Object[])new Object[0]);
        if (tool == null) {
            throw new RuntimeException("Can't get tool instance: " + args[0]);
        }
        System.setProperty("sqoop.kill_tomcat_on_load_failure", "false");
        System.out.println("Running tool: " + toolClass);
        if (tool.runTool(Arrays.copyOfRange(args, 1, args.length))) {
            System.out.println("Tool " + toolClass + " has finished correctly.");
        } else {
            System.out.println("Tool " + toolClass + " has failed.");
            System.exit(1);
        }
    }

    private ToolRunner() {
    }
}

