/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tomcat;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.catalina.Host;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.ExpandWar;

public class TomcatToolRunner {
    private static String PROPERTY_APPBASE_PATH = "org.apache.sqoop.tomcat.webapp.path";
    private static String DEFAULT_APPBASE_PATH = "webapps";

    public static void main(String[] args) throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.init();
        String webappPath = System.getProperty(PROPERTY_APPBASE_PATH, DEFAULT_APPBASE_PATH);
        String catalinaBase = Bootstrap.getCatalinaBase();
        String fullWebappPath = catalinaBase + File.separator + webappPath;
        String fullSqoopWarPath = fullWebappPath + File.separator + "sqoop.war";
        String fullSqoopClassesPath = fullWebappPath + File.separator + "sqoop" + File.separator + "WEB-INF" + File.separator + "classes";
        String fullSqoopLibPath = fullWebappPath + File.separator + "sqoop" + File.separator + "WEB-INF" + File.separator + "lib";
        Embedded embedded = new Embedded();
        Host host = embedded.createHost("Sqoop Tool Virtual Host", fullWebappPath);
        ExpandWar.expand((Host)host, (URL)new URL("jar:file://" + fullSqoopWarPath + "!/"));
        File[] unpacked = new File[]{new File(fullSqoopClassesPath)};
        File[] packed = new File[]{new File(fullSqoopLibPath)};
        ClassLoader loader = ClassLoaderFactory.createClassLoader((File[])unpacked, (File[])packed, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> klass = Class.forName("org.apache.sqoop.tools.ToolRunner", true, loader);
        Method method = klass.getMethod("main", String[].class);
        method.invoke(null, new Object[]{args});
    }
}

