/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;

public class SQLServerMultiMapsManualTest
extends ImportJobTestCase {
    @Override
    public void setUp() {
        super.setUp();
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.createTableFromSQL("CREATE TABLE TPCH1M_LINEITEM( [L_ORDERKEY] [int] NULL, [L_PARTKEY] [int] NULL, [L_SUPPKEY] [int] NULL, [L_LINENUMBER] [int] NULL, [L_QUANTITY] [int] NULL, [L_EXTENDEDPRICE] [decimal](15, 2) NULL, [L_DISCOUNT] [decimal](15, 2) NULL, [L_TAX] [decimal](15, 2) NULL, [L_RETURNFLAG] [varchar](max) NULL, [L_LINESTATUS] [varchar](max) NULL, [L_SHIPDATE] [varchar](max) NULL, [L_COMMITDATE] [varchar](max) NULL, [L_RECEIPTDATE] [varchar](max) NULL, [L_SHIPINSTRUCT] [varchar](max) NULL, [L_SHIPMODE] [varchar](max) NULL, [L_COMMENT] [varchar](max) NULL) ");
            utils.populateLineItem();
        }
        catch (SQLException e) {
            LOG.error((Object)("Setup fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerMultiMapsManualTest.fail((String)("Setup fail with SQLException: " + e.toString()));
        }
    }

    @Override
    public void tearDown() {
        super.tearDown();
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.dropTableIfExists("TPCH1M_LINEITEM");
        }
        catch (SQLException e) {
            LOG.error((Object)("TeatDown fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerMultiMapsManualTest.fail((String)("TearDown fail with SQLException: " + e.toString()));
        }
    }

    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, String splitByCol) {
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        args.add("--table");
        args.add(this.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--username");
        args.add(username);
        args.add("--password");
        args.add(password);
        args.add("--as-sequencefile");
        args.add("--num-mappers");
        args.add("2");
        return args.toArray(new String[0]);
    }

    protected List<Path> getDataFilePaths() throws IOException {
        FileStatus[] stats;
        ArrayList<Path> paths = new ArrayList<Path>();
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (FileStatus stat : stats = fs.listStatus(this.getTablePath(), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter())) {
            paths.add(stat.getPath());
        }
        return paths;
    }

    private int getFirstInt(String str) {
        String[] parts = str.split(",");
        return Integer.parseInt(parts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runMultiMapTest(String splitByCol, int expectedSum) throws IOException {
        String[] columns = MSSQLTestUtils.getColumns();
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, columns, splitByCol);
        this.runImport(argv);
        try {
            ImportTool importTool = new ImportTool();
            SqoopOptions opts = importTool.parseArguments(this.getArgv(false, columns, splitByCol), null, null, true);
            String username = MSSQLTestUtils.getDBUserName();
            String password = MSSQLTestUtils.getDBPassWord();
            opts.setUsername(username);
            opts.setPassword(password);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            List<Path> paths = this.getDataFilePaths();
            Configuration conf = new Configuration();
            int curSum = 0;
            for (Path p : paths) {
                reader = SeqFileReader.getSeqFileReader(p.toString());
                Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                while (reader.next(key) != null) {
                    reader.getCurrentValue(val);
                    curSum += this.getFirstInt(val.toString());
                }
                IOUtils.closeStream((Closeable)reader);
                reader = null;
            }
            SQLServerMultiMapsManualTest.assertEquals((String)"Total sum of first db column mismatch", (int)expectedSum, (int)curSum);
            IOUtils.closeStream(reader);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
            SQLServerMultiMapsManualTest.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)pe));
            SQLServerMultiMapsManualTest.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testSplitByFirstCol() throws IOException {
        this.runMultiMapTest("L_ORDERKEY", 10);
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opt = new SqoopOptions(conf);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opt;
    }

    SqoopOptions getSqoopOptions(String[] args, SqoopTool tool) {
        SqoopOptions opts = null;
        try {
            opts = tool.parseArguments(args, null, null, true);
            String username = MSSQLTestUtils.getDBUserName();
            String password = MSSQLTestUtils.getDBPassWord();
            opts.setUsername(username);
            opts.setPassword(password);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            SQLServerMultiMapsManualTest.fail((String)("Invalid options: " + e.toString()));
        }
        return opts;
    }

    @Override
    protected String getTableName() {
        return "tpch1m_lineitem";
    }
}

