/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle.util;

import org.apache.sqoop.manager.oracle.util.OraOopTestDataGenerator;

public class IntervalDaySecondGenerator
extends OraOopTestDataGenerator<String> {
    private final int daysPrecision;
    private final int minDays;
    private final int maxDays;
    private final int secondsPrecision;
    private final int maxFractionalSeconds;

    public IntervalDaySecondGenerator(int daysPrecision, int secondsPrecision) {
        this.daysPrecision = daysPrecision;
        this.minDays = -((int)Math.pow(10.0, daysPrecision)) + 1;
        this.maxDays = (int)Math.pow(10.0, daysPrecision) - 1;
        this.secondsPrecision = secondsPrecision;
        this.maxFractionalSeconds = (int)Math.pow(10.0, secondsPrecision);
    }

    @Override
    public String next() {
        int days = this.minDays + this.rng.nextInt(this.maxDays - this.minDays + 1);
        int hours = this.rng.nextInt(24);
        int minutes = this.rng.nextInt(60);
        int seconds = this.rng.nextInt(60);
        int fractionalSeconds = this.rng.nextInt(this.maxFractionalSeconds);
        String val = String.format("%+0" + this.daysPrecision + "d %02d:%02d:%02d.%0" + this.secondsPrecision + "d", days, hours, minutes, seconds, fractionalSeconds);
        return val;
    }
}

