/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.netezza;

import com.cloudera.sqoop.SqoopOptions;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.sqoop.hcat.HCatalogExportTest;
import org.apache.sqoop.hcat.HCatalogTestUtils;
import org.apache.sqoop.manager.NetezzaManager;
import org.apache.sqoop.manager.netezza.NetezzaTestUtils;
import org.junit.Before;

public class DirectNetezzaHCatExportManualTest
extends HCatalogExportTest {
    private NetezzaManager manager;

    @Override
    protected String getConnectString() {
        return NetezzaTestUtils.getNZConnectString();
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected Connection getConnection() {
        try {
            return this.manager.getConnection();
        }
        catch (SQLException sqle) {
            throw new AssertionError((Object)sqle.getMessage());
        }
    }

    @Override
    protected void runHCatExport(List<String> addlArgsArray, int totalRecords, String table, HCatalogTestUtils.ColumnGenerator[] cols) throws Exception {
        addlArgsArray.add("--direct");
        addlArgsArray.add("--username");
        addlArgsArray.add(NetezzaTestUtils.getNZUser());
        addlArgsArray.add("--password");
        addlArgsArray.add(NetezzaTestUtils.getNZPassword());
        addlArgsArray.add("--num-mappers");
        addlArgsArray.add("1");
        super.runHCatExport(addlArgsArray, totalRecords, table, cols);
    }

    public void setUpNZ() {
        SqoopOptions options = new SqoopOptions(NetezzaTestUtils.getNZConnectString(), this.getTableName());
        options.setUsername(NetezzaTestUtils.getNZUser());
        options.setPassword(NetezzaTestUtils.getNZPassword());
        this.manager = new NetezzaManager(options);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.setUpNZ();
    }

    @Override
    public void testIntTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "boolean", 16, HCatFieldSchema.Type.BOOLEAN, 0, 0, Boolean.TRUE, Boolean.TRUE, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "smallint", 5, HCatFieldSchema.Type.INT, 0, 0, 100, (short)100, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "int", 4, HCatFieldSchema.Type.INT, 0, 0, 1000, 1000, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(3), "bigint", -5, HCatFieldSchema.Type.BIGINT, 0, 0, 10000L, 10000L, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    @Override
    public void testStringTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "char(14)", 1, HCatFieldSchema.Type.STRING, 0, 0, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    @Override
    public void testNumberTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "numeric(18,2)", 2, HCatFieldSchema.Type.STRING, 0, 0, "1000.00", new BigDecimal("1000.00"), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "decimal(18,2)", 3, HCatFieldSchema.Type.STRING, 0, 0, "2000.00", new BigDecimal("2000.00"), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    @Override
    public void testBinaryTypes() throws Exception {
    }

    @Override
    public void testColumnProjection() throws Exception {
    }

    @Override
    public void testStaticPartitioning() throws Exception {
    }

    @Override
    public void testDynamicPartitioning() throws Exception {
    }

    @Override
    public void testStaticAndDynamicPartitioning() throws Exception {
    }

    @Override
    public void testSequenceFile() throws Exception {
    }

    @Override
    public void testTextFile() throws Exception {
    }
}

