/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSqlManager
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestSqlManager.class.getName());
    static final String MISSING_TABLE = "MISSING_TABLE";
    private HsqldbTestServer testServer;
    private ConnManager manager;
    static final int EXPECTED_NUM_ROWS = 4;
    static final int EXPECTED_COL1_SUM = 16;
    static final int EXPECTED_COL2_SUM = 20;
    static final String TABLE_WITH_KEY = "TABLE_WITH_KEY";
    static final String KEY_FIELD_NAME = "KEYFIELD";

    @Before
    public void setUp() {
        this.testServer = new HsqldbTestServer();
        try {
            this.testServer.resetServer();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestSqlManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)("Could not find class for db driver: " + cnfe.toString()));
            TestSqlManager.fail((String)("Could not find class for db driver: " + cnfe.toString()));
        }
        this.manager = this.testServer.getManager();
    }

    @After
    public void tearDown() {
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestSqlManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testListColNames() {
        String[] colNames = this.manager.getColumnNames(HsqldbTestServer.getTableName());
        TestSqlManager.assertNotNull((String)"manager returned no colname list", (Object)colNames);
        TestSqlManager.assertEquals((String)"Table list should be length 2", (int)2, (int)colNames.length);
        String[] knownFields = HsqldbTestServer.getFieldNames();
        for (int i = 0; i < colNames.length; ++i) {
            TestSqlManager.assertEquals((String)knownFields[i], (String)colNames[i]);
        }
    }

    @Test
    public void testListColTypes() {
        Map types = this.manager.getColumnTypes(HsqldbTestServer.getTableName());
        TestSqlManager.assertNotNull((String)"manager returned no types map", (Object)types);
        TestSqlManager.assertEquals((String)"Map should be size=2", (int)2, (int)types.size());
        TestSqlManager.assertEquals((int)((Integer)types.get("INTFIELD1")), (int)4);
        TestSqlManager.assertEquals((int)((Integer)types.get("INTFIELD2")), (int)4);
    }

    @Test
    public void testMissingTableColNames() {
        String[] colNames = this.manager.getColumnNames(MISSING_TABLE);
        TestSqlManager.assertNull((String)"No column names should be returned for missing table", (Object)colNames);
    }

    @Test
    public void testMissingTableColTypes() {
        Map colTypes = this.manager.getColumnTypes(MISSING_TABLE);
        TestSqlManager.assertNull((String)"No column types should be returned for missing table", (Object)colTypes);
    }

    @Test
    public void testListTables() {
        String[] tables;
        for (String table : tables = this.manager.listTables()) {
            System.err.println("Got table: " + table);
        }
        TestSqlManager.assertNotNull((String)"manager returned no table list", (Object)tables);
        TestSqlManager.assertEquals((String)"Table list should be length 1", (int)1, (int)tables.length);
        TestSqlManager.assertEquals((String)HsqldbTestServer.getTableName(), (String)tables[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTable() {
        ResultSet results = null;
        try {
            results = this.manager.readTable(HsqldbTestServer.getTableName(), HsqldbTestServer.getFieldNames());
            TestSqlManager.assertNotNull((String)"ResultSet from readTable() is null!", (Object)results);
            ResultSetMetaData metaData = results.getMetaData();
            TestSqlManager.assertNotNull((String)"ResultSetMetadata is null in readTable()", (Object)metaData);
            TestSqlManager.assertEquals((String)"Number of returned columns was unexpected!", (int)metaData.getColumnCount(), (int)HsqldbTestServer.getFieldNames().length);
            int sumCol1 = 0;
            int sumCol2 = 0;
            int rowCount = 0;
            while (results.next()) {
                ++rowCount;
                sumCol1 += results.getInt(1);
                sumCol2 += results.getInt(2);
            }
            TestSqlManager.assertEquals((String)"Expected 4 rows back", (int)4, (int)rowCount);
            TestSqlManager.assertEquals((String)"Expected left sum of 16", (int)16, (int)sumCol1);
            TestSqlManager.assertEquals((String)"Expected right sum of 20", (int)20, (int)sumCol2);
        }
        catch (SQLException sqlException) {
            TestSqlManager.fail((String)("SQL Exception: " + sqlException.toString()));
        }
        finally {
            if (null != results) {
                try {
                    results.close();
                }
                catch (SQLException sqlE) {
                    TestSqlManager.fail((String)("SQL Exception in ResultSet.close(): " + sqlE.toString()));
                }
            }
            this.manager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadMissingTable() {
        ResultSet results = null;
        try {
            String[] colNames = new String[]{"*"};
            results = this.manager.readTable(MISSING_TABLE, colNames);
            TestSqlManager.assertNull((String)"Expected null resultset from readTable(MISSING_TABLE)", (Object)results);
        }
        catch (SQLException sqlException) {
        }
        finally {
            if (null != results) {
                try {
                    results.close();
                }
                catch (SQLException sqlE) {
                    TestSqlManager.fail((String)("SQL Exception in ResultSet.close(): " + sqlE.toString()));
                }
            }
            this.manager.release();
        }
    }

    @Test
    public void getPrimaryKeyFromMissingTable() {
        String primaryKey = this.manager.getPrimaryKey(MISSING_TABLE);
        TestSqlManager.assertNull((String)"Expected null pkey for missing table", (Object)primaryKey);
    }

    @Test
    public void getPrimaryKeyFromTableWithoutKey() {
        String primaryKey = this.manager.getPrimaryKey(HsqldbTestServer.getTableName());
        TestSqlManager.assertNull((String)"Expected null pkey for table without key", (Object)primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getPrimaryKeyFromTable() {
        Connection conn = null;
        try {
            conn = this.testServer.getConnection();
            PreparedStatement statement = conn.prepareStatement("CREATE TABLE TABLE_WITH_KEY(KEYFIELD INT NOT NULL PRIMARY KEY, foo INT)", 1003, 1007);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException sqlException) {
            TestSqlManager.fail((String)("Could not create table with primary key: " + sqlException.toString()));
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Got SQLException during close: " + sqlE.toString()));
                }
            }
        }
        String primaryKey = this.manager.getPrimaryKey(TABLE_WITH_KEY);
        TestSqlManager.assertEquals((String)"Expected null pkey for table without key", (String)primaryKey, (String)KEY_FIELD_NAME);
    }
}

