/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MySQLTestUtils {
    public static final Log LOG = LogFactory.getLog((String)MySQLTestUtils.class.getName());
    public static final String HOST_URL = System.getProperty("sqoop.test.mysql.connectstring.host_url", "jdbc:mysql://localhost/");
    public static final String MYSQL_DATABASE_NAME = "sqooptestdb";
    public static final String TABLE_NAME = "EMPLOYEES_MYSQL";
    public static final String CONNECT_STRING = HOST_URL + "sqooptestdb";

    private MySQLTestUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentUser() {
        String envUser = System.getenv("USER");
        if (null != envUser) {
            return envUser;
        }
        String[] whoamiArgs = new String[]{"whoami"};
        Process p = null;
        BufferedReader r = null;
        try {
            p = Runtime.getRuntime().exec(whoamiArgs);
            InputStream is = p.getInputStream();
            r = new BufferedReader(new InputStreamReader(is));
            String string = r.readLine();
            return string;
        }
        catch (IOException ioe) {
            LOG.error((Object)("IOException reading from `whoami`: " + ioe.toString()));
            String string = null;
            return string;
        }
        finally {
            if (null != r) {
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException closing input stream from `whoami`: " + ioe.toString()));
                }
            }
            while (p != null) {
                try {
                    int ret = p.waitFor();
                    if (0 == ret) continue;
                    LOG.error((Object)("whoami exited with error status " + ret));
                    return null;
                }
                catch (InterruptedException ie) {
                }
            }
        }
    }
}

