/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class TestTargetDir
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestTargetDir.class.getName());

    protected ArrayList getOutputArgv(boolean includeHadoopFlags) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(HsqldbTestServer.getTableName());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--split-by");
        args.add("INTFIELD1");
        args.add("--as-sequencefile");
        return args;
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    public void testSeveralOutputsIOException() throws IOException {
        try {
            ArrayList args = this.getOutputArgv(true);
            args.add("--warehouse-dir");
            args.add(this.getWarehouseDir());
            args.add("--target-dir");
            args.add(this.getWarehouseDir());
            String[] argv = args.toArray(new String[0]);
            this.runImport(argv);
            TestTargetDir.fail((String)"warehouse-dir & target-dir were set and run without problem reported");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testTargetDir() throws IOException {
        try {
            String targetDir = this.getWarehouseDir() + "/tempTargetDir";
            ArrayList args = this.getOutputArgv(true);
            args.add("--target-dir");
            args.add(targetDir);
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            Path outputPath = new Path(targetDir);
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, true);
            }
            String[] argv = args.toArray(new String[0]);
            this.runImport(argv);
            ContentSummary summ = fs.getContentSummary(outputPath);
            TestTargetDir.assertTrue((String)"There's no new imported files in target-dir", (summ.getFileCount() > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.error((Object)("Got Exception: " + StringUtils.stringifyException((Throwable)e)));
            TestTargetDir.fail((String)e.toString());
        }
    }

    public void testExistingTargetDir() throws IOException {
        try {
            String targetDir = this.getWarehouseDir() + "/tempTargetDir";
            ArrayList args = this.getOutputArgv(true);
            args.add("--target-dir");
            args.add(targetDir);
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            Path outputPath = new Path(targetDir);
            if (!fs.exists(outputPath)) {
                fs.mkdirs(outputPath);
            }
            String[] argv = args.toArray(new String[0]);
            this.runImport(argv);
            TestTargetDir.fail((String)"Existing target-dir run without problem report");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

