/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.tool.MainframeImportTool;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMainframeImportTool
extends BaseSqoopTestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMainframeImportTool.class.getName());
    private MainframeImportTool mfImportTool;

    @Override
    @Before
    public void setUp() {
        this.mfImportTool = new MainframeImportTool();
    }

    @Override
    @After
    public void tearDown() {
        System.setOut(null);
    }

    @Test
    public void testGetImportOptions() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] types = new Class[]{};
        Object[] params = new Object[]{};
        Method m_getImportOptions = MainframeImportTool.class.getDeclaredMethod("getImportOptions", types);
        m_getImportOptions.setAccessible(true);
        RelatedOptions rOptions = (RelatedOptions)m_getImportOptions.invoke((Object)this.mfImportTool, params);
        TestMainframeImportTool.assertNotNull((String)"It should return a RelatedOptions", (Object)rOptions);
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("dataset"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("delete-target-dir"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("target-dir"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("warehouse-dir"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("as-textfile"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("num-mappers"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("mapreduce-job-name"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("compress"));
        TestMainframeImportTool.assertTrue((boolean)rOptions.hasOption("compression-codec"));
    }

    @Test
    public void testApplyOptions() throws SqoopOptions.InvalidOptionsException, ParseException {
        String[] args = new String[]{"--dataset", "dummy_ds"};
        ToolOptions toolOptions = new ToolOptions();
        SqoopOptions sqoopOption = new SqoopOptions();
        this.mfImportTool.configureOptions(toolOptions);
        sqoopOption = this.mfImportTool.parseArguments(args, null, sqoopOption, false);
        TestMainframeImportTool.assertEquals((String)sqoopOption.getConnManagerClassName(), (String)"org.apache.sqoop.manager.MainframeManager");
        TestMainframeImportTool.assertEquals((String)sqoopOption.getTableName(), (String)"dummy_ds");
    }

    @Test
    public void testNotApplyOptions() throws ParseException, SqoopOptions.InvalidOptionsException {
        String[] args = new String[]{"--connection-manager=dummy_ClassName"};
        ToolOptions toolOptions = new ToolOptions();
        SqoopOptions sqoopOption = new SqoopOptions();
        this.mfImportTool.configureOptions(toolOptions);
        sqoopOption = this.mfImportTool.parseArguments(args, null, sqoopOption, false);
        TestMainframeImportTool.assertEquals((String)sqoopOption.getConnManagerClassName(), (String)"dummy_ClassName");
        TestMainframeImportTool.assertNull((Object)sqoopOption.getTableName());
    }
}

