/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.sqoop.mapreduce.db.DBConfiguration;

public class TestDBConfiguration
extends TestCase {
    public void testPropertiesToString() {
        Properties connParams = new Properties();
        connParams.setProperty("a", "value-a");
        connParams.setProperty("b", "value-b");
        connParams.setProperty("a.b", "value-a.b");
        connParams.setProperty("a.b.c", "value-a.b.c");
        connParams.setProperty("aaaaaaaaaa.bbbbbbb.cccccccc", "value-abc");
        String result = DBConfiguration.propertiesToString((Properties)connParams);
        Properties resultParams = DBConfiguration.propertiesFromString((String)result);
        TestDBConfiguration.assertEquals((String)"connection params don't match", (Object)connParams, (Object)resultParams);
        connParams = new Properties();
        connParams.put("conn.timeout", "3000");
        connParams.put("conn.buffer_size", "256");
        connParams.put("conn.dummy", "dummy");
        connParams.put("conn.foo", "bar");
        result = DBConfiguration.propertiesToString((Properties)connParams);
        resultParams = DBConfiguration.propertiesFromString((String)result);
        TestDBConfiguration.assertEquals((String)"connection params don't match", (Object)connParams, (Object)resultParams);
        connParams = new Properties();
        connParams.put("user", "ABC");
        connParams.put("password", "complex\"pass,word\\123");
        connParams.put("complex\"param,\\name", "dummy");
        connParams.put("conn.buffer=size", "256");
        connParams.put("jdbc.property", "a=b");
        result = DBConfiguration.propertiesToString((Properties)connParams);
        resultParams = DBConfiguration.propertiesFromString((String)result);
        TestDBConfiguration.assertEquals((String)"connection params don't match", (Object)connParams, (Object)resultParams);
    }
}

